function [isok] = dmri_script_file_create(filename)
% Create template script file which contains path setting.
%
% [Usage]
%    [isok] = dmri_script_file_create(filename);
%
% [Input]
%    filename : template script(bash) filename.
%
% [Output]
%    isok : = true  : script creation success.
%           = false : script creation failure.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
dmri_setenv;
if isempty(getenv('BASH_PROF'))
    error('dmri settings not found. please execute dmri_setenv.m');
end

%
% --- Main Procedure
%
isok = true;
fid = fopen(filename, 'wt');
if fid == -1
    isok = false;
    return;
end

% Create bash script and write tool path settings.
fprintf(fid, ['#!', getenv('BASH_PATH') '\n']);
fprintf(fid, ['source ' getenv('BASH_PROF') '\n\n']);
fclose(fid);
system(['chmod 755 ' filename]);
