function p = dmri_set_parm_tutorial()
% Set parameter for DMRI data processing
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

p = struct;

% T1 data
p.t1_dicom_dir          = '/home/cbi-data5/DTI/sample/3D';   % T1 data directory
p.t1_dicom_extension    = '.dcm';
p.t1_brain_threshold    = 0.5;   % threshold value to extract brain mask (from 0 to 1.0)
                                 % default = 0.5

% Diffusion MRI data
p.dmri_dicom_dir        = '/home/cbi-data5/DTI/sample/DTI';  % Diffusion MRI data directory
p.dmri_dicom_extension  = '.dcm';
p.dmri_brain_threshold  = 0.18;  % threshold value to extract brain mask (from 0 to 1.0)
                                 % default = 0.18

% Pacellation method
p.parcel_method         = 'equal'; % 'equal' : Parcel cortical surface equally.
                                   % 'area'  : Parcel cortical surface based on specified area file.
                                   %           (p.ref_parcel_area_file). if the area file not specified,
                                   %           AAL area file is automatically set.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Output
%
p.output_dir       = '/home/cbi-data5/DTI/processed';

% Fiber tracking Host
%   Available hosts are:
%     - cbi-node20-33
%     - cbi-node01g-08g
%     - cbi-node20g-23g
p.hosts   = {'cbi-node21','cbi-node22', 'cbi-node23'};

% MATLAB process number.
%  - The number of MATLAB to process fiber tracking result files.
%  - Less than the number of CPU cores which runs this script.
p.Nworker = 20;

%
% --- Reference files (Optional)
%
% * if you specify these parameters, 
%   create step of them are skipped and they are used to process.

% T1 file
p.ref_mri_file       = ''; % '/home/cbi-data5/DTI/processed/struct/mSubject.nii';
                           % Bias corrected NIfTi file(.nii) created by VBMEG
                           % (e.g. mSubject.nii)

% FreeSurfer subject directory
p.ref_fs_dir         = ''; % '/home/cbi-data5/DTI/processed/freesurfer/Subject';
                           % The data which is created from p.ref_mri_file.

% VBMEG files
p.ref_brain_file     = ''; % '/home/cbi-data5/DTI/processed/vbmeg/Subject.brain.mat';
                           % .brain.mat
p.ref_aal_area_file  = ''; % '/home/cbi-data5/DTI/processed/vbmeg/Subject_aal.area.mat';
                           % _aal.area.mat
                           % These files should be created from p.ref_fs_dir.

p.ref_parcel_area_file = '';    % '/home/cbi-data5/DTI/processed/vbmeg/Subject_aal.area.mat';
                                % This option is used with p.parcel_method = 'area'.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Directory/filename definition
%
p.t1_dirname               = 'struct';
p.dwi_dirname              = 'DWI';
p.fs_dirname               = 'freesurfer';
p.vbmeg_dirname            = 'vbmeg';
p.parcels_dirname          = 'parcels';
p.fiber_track_dirname      = 'fibertrack';
p.transform_info_dirname   = 'transwarp_info';
p.connectivity_dirname     = 'connectivity';

p.t1_file                  = 'Subject.nii';            % t1_dir
p.t1_brain_basename        = 'struct';                 % t1_dir
p.dwi_basename             = 'data_dwi';               % dwi_dir
p.FA_coreg_basename        = 'data_FA_coreg';          % dwi_dir
p.FA_basename              = 'data_FA';                % dwi_dir
p.fs_sbj_name              = 'Subject';                % freesurfer_dir
p.trans_struct2fa_file     = 'struct2fa_warp.nii.gz';  % transform_dir
p.trans_fs2struct          = 'freesurfer2struct.mat';  % transform_dir
p.parcels_file             = 'parcels.mat';            % parcels_dir
p.parcels_mm_coord_file    = 'parcels_mm_coord.mat';   % parcels_dir
p.vbmeg_cortex_basename    = 'Subject';                % vbmeg_dir
p.fiber_mask_file          = 'parcel_wm.nii.gz';       % fiber_track_dir
p.fiber_resp_area_file     = 'sf.nii.gz';              % fiber_track_dir
p.fiber_mif_file           = 'CSD6.mif';               % fiber_track_dir
p.anat_matrix_file         = 'anat_matrix.mat';        % fiber_track_dir
p.dmri_file                = 'connectivity.dmri.mat';  % connectivity_dir

