function	[Nvert,Npart,name] = vb_plot_non_atlas_area(brainfile,atlasfile)
% Plot non-atlas area in brain 
%  vb_plot_non_atlas_area(brainfile,atlasfile)
% --- Input
% brainfile
% atlasfile
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[V, F, xx, inf_C] = vb_load_cortex(brainfile,'Inflate');

NL = F.NdipoleL;
FL = F.F3L;
FR = F.F3R;
F  = F.F3;
NV = size(V,1);

load(atlasfile,'Act')

ixlist = find( Act{1}.xxP == 0 );

NLz = sum(ixlist <= NL);
NRz = sum(ixlist > NL);

fprintf('N_left = %d, N_right = %d\n',NLz,NRz)

% Color of Inflate model
colors = vb_get_inflate_color(inf_C);

angl = [ 10 45 ; -10 45; 90 10; -90 10; 35  20; -35  20];
nL = 3;
nR = 4;

Lmax = max(V(1:NL,:));
Lmin = min(V(1:NL,:));
Rmax = max(V((NL+1):NV,:));
Rmin = min(V((NL+1):NV,:));

subplot(1,2,1)
patch('Faces',FL,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',colors);
hold on;

Fx = vb_patch_select2(ixlist,FL,NV);
vb_plot_surf(V,Fx,'r');

xlim([Lmin(1) Lmax(1)]);
ylim([Lmin(2) Lmax(2)]);
zlim([Lmin(3) Lmax(3)]);

view(angl(nL,:));

subplot(1,2,2)
patch('Faces',FR,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',colors);
hold on;

Fx = vb_patch_select2(ixlist,FR,NV);
vb_plot_surf(V,Fx,'r');

xlim([Rmin(1) Rmax(1)]);
ylim([Rmin(2) Rmax(2)]);
zlim([Rmin(3) Rmax(3)]);

view(angl(nR,:));

% connected region number
[Nvert,Npart,name] = vb_find_atlas_label_number(atlasfile,brainfile);

Narea = length(Act{1}.label);
Nmax = max(Npart);
Mvert = zeros(Narea+1,Nmax);

for n=1:Narea+1
	if Npart(n) > 0
		Mvert(n,1:Npart(n)) = Nvert{n};
	end
end

iz = find(Npart==0);
miss = {name{iz}};

figure;
subplot 211
plot(Npart)

subplot 212
plot(Mvert)

return
