function	vb_plot_brodmann_area(brainfile,atlasfile,Nlist,Subfig)
% Plot selected brodmann atlas
%  vb_plot_brodmann_area(brainfile,atlasfile)
%  vb_plot_brodmann_area(brainfile,atlasfile,Nlist,Subfig)
% --- Input
% brainfile
% atlasfile
% Nlist : number of area list
%         Brodmann area numbers are devided into set of area number list
%         area_list = vb_get_brodmann_area_list(Nlist)
% Subfig: subplot number = [# of X-axis , # of Y-axis]
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

cmap = {'r','y','c','m','b','g'};
alpha_val = 1; %0.9;

if nargin < 3, Nlist = 0; end;

if nargin < 4
	NY = 2;
	NX = 3;
else
	NX = Subfig(1);
	NY = Subfig(2);
end

list = vb_get_brodmann_area_list(Nlist);

Nfig = NX*NY;

[V, F, xx, inf_C] = vb_load_cortex(brainfile,'Inflate');

NL = F.NdipoleL;
FL = F.F3L;
FR = F.F3R;
F  = F.F3;
NV = size(V,1);

load(atlasfile);

Atlas = Act{1};
label = Atlas.label      ; % label value;
xxP = Atlas.xxP; 

% Color of Inflate model
colors = vb_get_inflate_color(inf_C);

angl = [ 10 45 ; -10 45; -60 10; 60 10; 35  20; -35  20];
angl = [ 10 70 ; -10 45; -60 10; 60 10; 35  20; -35  20];

Lmax = max(V(1:NL,:));
Lmin = min(V(1:NL,:));
Rmax = max(V((NL+1):NV,:));
Rmin = min(V((NL+1):NV,:));
%
% --- Left
%
Nlist = length(list);
nfig = Nfig;

for n = 1:Nlist
	if nfig==Nfig,
		figure;
		nfig = 0;
	end
	
	nfig = nfig + 1;
	nsub = 0;
	
	subplot(NY,NX,nfig)
	patch('Faces',FL,'Vertices',V,'FaceColor','interp',...
		'EdgeColor','none','FaceVertexCData',colors);
	hold on;
	
	for m = list{n}
		ix = find(xxP == m);
		if isempty(ix), continue; end;
		Fx = vb_patch_select2(ix,FL,NV);
		if isempty(Fx), continue; end
		nsub = nsub + 1;
		vb_plot_surf(V,Fx,cmap{nsub});
	end
	
	xlim([Lmin(1) Lmax(1)]);
	ylim([Lmin(2) Lmax(2)]);
	zlim([Lmin(3) Lmax(3)]);
	view(angl(1,:));
	title(['L ' sprintf('%d ',list{n})])
	alpha(alpha_val)
	
end

%return
%
% --- Right
%
nfig = Nfig;

for n = 1:Nlist
	if nfig==Nfig,
		figure;
		nfig = 0;
	end
	
	nfig = nfig + 1;
	nsub = 0;
	
	subplot(NY,NX,nfig)
	patch('Faces',FR,'Vertices',V,'FaceColor','interp',...
		'EdgeColor','none','FaceVertexCData',colors);
	hold on;
	
	for m = list{n}
		ix = find(xxP == m + 1000);
		if isempty(ix), continue; end;
		Fx = vb_patch_select2(ix,FR,NV);
		if isempty(Fx), continue; end
		nsub = nsub + 1;
		vb_plot_surf(V,Fx,cmap{nsub});
	end
	
	xlim([Rmin(1) Rmax(1)]);
	ylim([Rmin(2) Rmax(2)]);
	zlim([Rmin(3) Rmax(3)]);
	view(angl(1,:));
	title(['R ' sprintf('%d ',list{n})])
	alpha(alpha_val)
	
	
end
