function	[dim, Trans, XYZmm] = vb_get_image_info(fname)
% Read image header & get mm coordinate centered at origin
%  [dim, Trans, XYZmm] = vb_get_image_info(fname)
% --- Input
% fname : analyze file name
% --- Output
% dim(1:3) : XYZ-image dimension
% Trans : affine transformation from voxcel coord. to mm-coord at origin
% XYZmm = Trans * [XYZvox ; ones(1,Npoint)];
%       : mm coordinate centered at origin
%
%% 2006/11/14 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%fprintf('DEBUG\n')

% Read image-header
[dim, vox, origin] = analyze_hdr_read(fname);

% origin in voxcel-space -> origin in MNI-mm space
origin = vox(:) .* origin(:);

Trans  = [vox(1) 0 0 -origin(1) ; ...
          0 vox(2) 0 -origin(2) ; ...
          0 0 vox(3) -origin(3) ; ...
          0 0      0    1     ];

% XYZmm - 3 x n matrix of XYZ locations 
%          mm-coordinates in atlas-template (origin in MNI-space)
[X,Y,Z] = ndgrid(1:dim(1),1:dim(2),1:dim(3));

XYZmm   = [vox(1)*X(:)' - origin(1); ...
           vox(2)*Y(:)' - origin(2); ...
           vox(3)*Z(:)' - origin(3)];

clear X Y Z
