function	[ix_list, ix_name] = vb_get_atlas_label(ix_area,atlasfile,atlas_id)
% Get area index corresponding to atlas map in the given area
%
% [ix_list, ix_name] = vb_get_atlas_label(ix_area,atlasfile,atlas_id)
% --- Input
% ix_area : Vertex index for given area
% atlasfile : File name of subject atlas file (*.atlas.mat)
% atlas_id  : Atlas name ('aal', 'brodmann')
% --- Output
% ix_list : set of area index corresponding to atlas region
% ix_name : name of atlas region corresponding to 'ix_list'
%
%% 2006/11/14 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Get atlas label
Act        = vb_get_act(atlasfile,atlas_id);
Vlabel     = Act.xxP;
label      = Act.label;
label_name = Act.label_name;
dd_label   = Act.dd_label;

Npoint = length(Vlabel);
flg    = zeros(Npoint,1);
flg(ix_area) = 1;

Vlabel = Vlabel.*flg;
Nlabel = length(label);
ix_list = [];
ix_name = [];
Narea   = 0;

for n=1:Nlabel
	ix = find( Vlabel == label(n));

	if ~isempty(ix)
		Narea   = Narea + 1;
		ix_list{Narea} = ix;
		ix_name{Narea} = label_name{n};
	end
end

%return
