function	vb_atlas2vb_std(parm)
% vb_atlas2vb create an areafile based on the anatomical atlas
% 
% ---- Syntax
% vb_atlas2vb(parm)
%
% ---- Input (Field names in 'parm')
% atlas_id   : ID of atlas.
% atlas_text : atlas label name text file 
% atlas_file : atlas image file 
% save_areafile  : Area file saved
% save_atlasfile : Atlas file saved
% brainfile      : brain file;
%
% --- Function required  
%  explode      : string manupilation 
%
% ---- NOTE -----
% When using the normalize transformation matrix created by 'spm99',  
% back transformation results with a little shift 
% toward X(Left-Right) direction compared with brain file.
% It is highly recommended to recalculate 
% the transformation matrix by spm2 !!!
%
% 2005/03/03 OY
% 2005/03/28 modified 
% 2005/04/21 second part modified
% 2005/09/09 ver.030b compatible
% 2005/12/22 M.Sato
% 2006/2/3   M.Sato
% 2006/11/14 M.Sato
% 2007/03/05 OY
% * MNI coordinate is stored in brainfile.
% * save_xyzfile is removed.
% * A label for 'Corpus' is NaN.
% 2009-01-05 Taku Yoshioka
%   Supression of confirmation dialog
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

atlas_id   = parm.atlas_id;
atlas_text = parm.atlas_text; 
atlas_file = parm.atlas_file; 
brainfile  = parm.brainfile;

save_areafile  = parm.save_areafile;
save_atlasfile = parm.save_atlasfile;

% Max radius to check minimum distance to corresponding point [mm]
if	isfield(parm,'Rlimit')
	Rlimit = parm.Rlimit;
else
	Rlimit = 4; 
end
% Max radius to search corresponding point [mm] in the 1st-step
if	isfield(parm,'Rmax')
	Rmax = parm.Rmax;
else
	Rmax = 2; 
end

% In the 1st-step, nearest point is searched within Rmax
% In the 2nd-step, nearest point is searched for all candidates
% This value determine, efficiency of search,
% but does not change the result

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Don't modify %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Template file is neurological format (right handed spm).

% Standard brain cortex in MNI-mm coordinate (origin in MNI-space)
load(brainfile,'V','F')

NL = F.NdipoleL;
NP = size(V,1);
Vlabel	 = zeros(NP,1);

% Read atlas-template image 
% Zlabel - label for 3D image data (label value)
% XYZmm0 - 3 x n matrix of XYZ locations 
%          mm-coordinates in atlas-template (origin : AC-PC center)

avw = avw_img_read(atlas_file);
Zlabel = avw.img;

% Read image-header
[dim, Trans] = vb_get_image_info(atlas_file);

% convert to standard voxcel coordinate from mm-coordinate
Vox = [V*1000 ones(NP,1)] * inv(Trans');
Vox = round(Vox(:,1:3));

VL = Vox(1:NL,:);
VR = Vox(1+NL:end,:);

% Extract labeled left region
mni_L = sub2ind(dim, VL(:,1), VL(:,2), VL(:,3) );
mni_R = sub2ind(dim, VR(:,1), VR(:,2), VR(:,3) );

label_L = Zlabel(mni_L);
label_R = Zlabel(mni_R);

fprintf('--- Mapping Atlas-label onto 2D cortical surface \n');

% voxcel coordinate wuth label
ix_label = find(Zlabel(:) > 0);
[x,y,z] = ind2sub(dim,ix_label);
Zlabel = Zlabel(ix_label);

% Left non labeled points
ixL = find( label_L == 0 );	
% Find nearest labeled point in atlas
[indx, dd] = vb_find_nearest_point([x,y,z], VL(ixL,:), Rmax, 100, 0, 1);
% Find points whose minimum distance to atlas brain region is less than Rmax
ix_match = find( dd < Rmax & indx > 0 );

label_L(ixL(ix_match)) = Zlabel(indx(ix_match));

% Right non labeled points
ixR = find( label_R == 0 );	
% Find nearest labeled point in atlas
[indx, dd] = vb_find_nearest_point([x,y,z], VR(ixR,:), Rmax, 100, 0, 1);
% Find points whose minimum distance to atlas brain region is less than Rmax
ix_match = find( dd < Rmax & indx > 0 );

label_R(ixR(ix_match)) = Zlabel(indx(ix_match));

%
% ---- Save labeled area
%
ix_L = find( label_L ~= 0 );	% # of labeled points
ix_R = find( label_R ~= 0 );	% # of labeled points

label_R(ix_R) = label_R(ix_R) + 1000;

Vlabel(1:NL)     = label_L;
Vlabel(1+NL:end) = label_R;

% Read atlas text file and extract area keys.
[label, label_name] = vb_read_atlas_label(atlas_text);

% Save area label into area file
fprintf('Save the area file as "%s" \n', save_areafile);

label = [label , label + 1000];

N = length(label_name);
label_name2 = cell(2*N,1);

for n = 1:N
	name = strrep(label_name{n},'brodmann area ','');
	label_name2{n}   = [name '_L'];
	label_name2{n+N} = [name '_R'];
end	

vb_save_atlas_label(save_areafile,Vlabel,label,label_name2);

% Intensity of 'Act.xxP' is the label for each vertex
Atlas.key = [atlas_id];
Atlas.xxP = Vlabel;
Atlas.label      = label;
Atlas.label_name = label_name2;

% Save label as actfile
fprintf('Save the atlas file as "%s"  \n', save_atlasfile);
vb_add_act(save_atlasfile,Atlas,[],false);

fprintf('# of all vertex     = %d\n',NP)
fprintf('# of left labeled points  = %d/%d\n',length(ix_L),NL)
fprintf('# of right labeled points = %d/%d\n',length(ix_R),NP-NL)

%clear Zlabel Vlabel XYZmm0 XYZmm Zlabel
