function [meg_parm] = vb_set_meg_parm_brainamp
% set values to the meg_parm for vb_job_meg (BRAINAMP)
% [usage]
%   [meg_parm] = vb_set_meg_parm_biosemi(device_code)
% [input]
%   device_code : <optional> device code for 1) BRAINAMP
%               :  default is [1]
% [output]
%      meg_parm : <<struct>> meg_parm
%               :  .Measurement      : 'EEG'
%               :  .device           : 'BRAINAMP'
%               :  .measurement_file : input file (normally *.bdf)
%               :  .pos_file         : position file (*.pos.mat)
%               :  .output_file      : output file (normally *.eeg.mat)
% [note]
%
% [history]
%   2014/08/19 rhayashi initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('device_code', 'var') || isempty(device_code)
  device_code = 1;
end

func_ = mfilename;

% --- EEG --- %
if device_code == 1

  % --- REQUIRED --------------------------------------------------- %

  meg_parm = vb_meg_parm_set_measurement([], 'EEG', 'BRAINAMP');
  
% --- brainamp
% 
% subject
  meg_parm.measurement_file   = ''; % .eeg file
  meg_parm.pos_file           = ''; % .pos.mat file
  meg_parm.output_file        = ''; % .eeg.mat file

else
  error('(%s)undefined device_code : %d', func_, device_code);
end

%%% END OF FILE %%%
