function [dbayes_parm] = vb_set_dbayes_parm_test(proj_root)
% Parameter setting of "dbayes_parm" --- sample file
%  dbayes_parm = vb_set_dbayes_parm_test(proj_root)
%
% [Input]
%     proj_root  : Root directory of your data files.
%                  Inside project filename should be described as relative path.
% [Output]
%    dbayes_parm : Settings specific to dynamic estimation.
%
%  Copy this file to your local directory and modify according to your 
%  environment.
% 
% 2015/03/17 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- Initial Value file (inside project file: relative path from proj_root)
dbayes_parm.bayes_file = '/vbmeg/Subject_init_reduced_SCarea_rm.bayes.mat';

% --- Output file (inside project file: relative path from proj_root)
dbayes_parm.dbayes_file = '/vbmeg/Subject.dbayes.mat';

% --- Structural connectivity (fullpath)
dbayes_parm.dmri_file  = [proj_root '/connectivity/connectivity.dmri.mat'];

% --- MEG file(Optional) (Inside project file: relative path from proj_root)
dbayes_parm.meg_file    = ''; % if empty is specified, megfile in the 
                              % dbayes_parm.bayes_file is used for dynamics estimation.

% --- Specify current area (Optional)
% if you don't specify (or empty) these fields, the area specified by 
% 'vbmeg_area_ix' in *.dmri.mat file is used for dynamic estimation.
% dbayes_parm.area_key         = [];
% dbayes_parm.area_key_global  = []; %dbayes_parm.area_key;

%% --- Hyperparameters for the variance parameter of the MAR coefficients
dbayes_parm.ieta0 = 1e-2;
dbayes_parm.g0    = 1e2;

%% --- Iteration number
dbayes_parm.Ntrain     = 500;
