function [megfile, Measurement, Device] = vb_meg_parm_get_megfile(meg_parm)
% get MEG/EEG-MAT file from meg_parm.
% [USAGE]
%    [megfile, Measurement, Device] = vb_meg_parm_get_megfile(<meg_parm>)
% [IN]
%    meg_parm : meg_parm
% [OUT]
%        megfile : MEG/EEG-MAT file(relative path from proj_root)
%                  ('' is returned if meg_parm is unknown format.)
%    Measurement : Measurement type
%         Device : Device type
% [NOTE]
%    @see vb_meg_parm_set_measurement()
% [history]
%   2008-05-28 changed field name for EEG
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('meg_parm', 'var'), error('meg_parm is a required parameter.'); end

%
% --- Main Procedure
%
[Measurement, Device] = vb_meg_parm_get_measurement(meg_parm);

megfile = [];

% MEG-MAT
if strcmp(upper(Measurement), 'MEG')
    if isfield(meg_parm, 'meg_file') && ~isempty(meg_parm.meg_file)
        megfile = meg_parm.meg_file;
    else
        warning('meg_parm is unknown type.');
    end
% EEG-MAT
elseif strcmp(upper(Measurement), 'EEG')
    switch(Device)
        case {'BIOSEMI', 'BRAINAMP'}
            megfile = meg_parm.output_file;
        otherwise
            warning('meg_parm is unknown type.');
    end
end
