function plot_parm_new = vb_plotparmdlg(plot_parm0)
%
% Dialog for setting basic plot parameters
% 2004-03-16 Taku Yoshioka
%
% plot_parm.fs
% plot_parm.ms
% plot_parm.lw
% plot_parm.cmap
% plot_parm.wmode
% plot_parm.norm
% plot_parm.wmax
% plot_parm.wmin
% plot_parm.angle
% plot_parm.priority
% plot_parm.Rlabel
% plot_parm.zoom
% plot_parm.paint
% plot_parm.print_ratio
% plot_parm.print_size
% plot_parm.light
% plot_parm.width
% plot_parm.Jmax_ratio
% plot_parm.Jmin_ratio
%
% --- Inner functions
% init_global_variables
% set_GUI_state
% get_GUI_state
%
% --- Callback functions
% change_cmap
% change_display_mode
% change_priority
% change_paint
% change_LR
% change_normal_mode
% push_ok
% load_plot_parm
% save_plot_parm
%
% --- Global variables in select_area_variables
% plot_parm
% h
% 
% --- GUI handles
% ed1 (Font size)
% ed2 (Marker size)
% ed3 (Line width)
% ed4 (Max threshold)
% ed5 (Min threshold)
% ed6 (Angle)
% ed7 (Angle)
% ed8 (Rlabel)
% ed9 (Zoom)
% ed10 (print_ratio)
% ed11 (print_size)
% ed12 (width)
% rb1 (Colormap)
% rb2 (Display mode)
% rb3 (Priority)
% rb4 (Light)
% rb5 (Paint)
% rb6 (LRflag)
% rb7 (Normalization)
% 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% plot_parm0¤ΤǤʤдؿ̾Ȥߤʤ
% (ХåؿƤӽФ)
if ~isstruct(plot_parm0)
  eval(plot_parm0);
  return
end

% Initialize global variables
clear global plotparmdlg_variables
global plotparmdlg_variables;
init_global_variables(plot_parm0);

%handle = dialog('WindowStyle','modal');
handle = dialog('WindowStyle','normal');
plotparmdlg_variables.h = handle;
plot_parm = plotparmdlg_variables.plot_parm;

%
% Create GUI
%
m = 0.05;  % margin
x = m;     % origin (x)
y = m;     % origin (y)
w = 1-2*m; % width
h = 1-2*m; % height

dh = 1/18*h;
yy = y+17*dh;

% Font size
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Font size (>0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed1 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Marker size
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Marker size (>0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed2 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Line width
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Line width (>0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed3 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Colormap
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Colormap',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
rb1(1) = uicontrol('Style','radiobutton','String','hot',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_cmap(1)'')',...
		   'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
rb1(2) = uicontrol('Style','radiobutton','String','jet',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_cmap(2)'')',...
		   'Parent',handle);
yy = yy-dh;

% Display mode
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Display mode',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
rb2(1) = uicontrol('Style','radiobutton','String','absolute',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_display_mode(1)'')',...
		   'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
rb2(2) = uicontrol('Style','radiobutton','String','real value',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_display_mode(2)'')',...
		   'Parent',handle);
yy = yy-dh;

% Max threshold
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Max threshold (0.0-1.0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed4 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Min threshold
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Min threshold (0.0-1.0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed5 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Normalization mode
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Patch area normalization',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
rb7(1) = uicontrol('Style','radiobutton','String','Off',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_normal_mode(1)'')',...
		   'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
rb7(2) = uicontrol('Style','radiobutton','String','On',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_normal_mode(2)'')',...
		   'Parent',handle);
yy = yy-dh;

% Angle
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Angle (0-360)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
ed6 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
ed7 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Priority
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Priority',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
rb3(1) = uicontrol('Style','radiobutton','String','Distribution',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_priority(1)'')',...
		   'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
rb3(2) = uicontrol('Style','radiobutton','String','Area',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_priority(2)'')',...
		   'Parent',handle);
yy = yy-dh;

% Rlabel
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Label distance (>=1.0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed8 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% zoom
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Zoom (>0.0)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed9 = uicontrol('Style','edit','Units','normalized',...
		'Position',pos,'Parent',handle);
yy = yy-dh;

% Paint mode
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Paint',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
rb5(1) = uicontrol('Style','radiobutton','String','Off',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_paint(1)'')',...
		   'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
rb5(2) = uicontrol('Style','radiobutton','String','On',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_paint(2)'')',...
		   'Parent',handle);
yy = yy-dh;

% LRflag
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Left/Right',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.163*w dh];
rb6(1) = uicontrol('Style','radiobutton','String','LR',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_LR(1)'')',...
		   'Parent',handle);
pos = [x+0.663*w yy 0.163*w dh];
rb6(2) = uicontrol('Style','radiobutton','String','L',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_LR(2)'')',...
		   'Parent',handle);
pos = [x+0.826*w yy 0.163*w dh];
rb6(3) = uicontrol('Style','radiobutton','String','R',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_LR(3)'')',...
		   'Parent',handle);
yy = yy-dh;

% Print ratio/size
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Print ratio(>0.0)/size(>0.0,cm)',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
ed10 = uicontrol('Style','edit','Units','normalized',...
		 'Position',pos,'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
ed11 = uicontrol('Style','edit','Units','normalized',...
		 'Position',pos,'Parent',handle);
yy = yy-dh;

% Colormap
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Lighting',...
	  'Units','normalized','Position',pos,...
	  'Parent',handle);
pos = [x+0.5*w yy 0.25*w dh];
rb4(1) = uicontrol('Style','radiobutton','String','off',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_light(1)'')',...
		   'Parent',handle);
pos = [x+0.75*w yy 0.25*w dh];
rb4(2) = uicontrol('Style','radiobutton','String','on',...
		   'Units','normalized','Position',pos,...
		   'Value',0,'Callback',...
		   'vb_plotparmdlg(''change_light(2)'')',...
		   'Parent',handle);
yy = yy-dh;

% Slice width
pos = [x yy 0.5*w dh];
uicontrol('Style','text','String','Slice width (>=0, integer)',...
	  'Units','normalized','Position',pos,'Parent',handle);
pos = [x+0.5*w yy 0.5*w dh];
ed12 = uicontrol('Style','edit','Units','normalized',...
		 'Position',pos,'Parent',handle);
yy = yy-dh;

% Buttons
pos = [x y 0.333*w dh];
uicontrol('Style','pushbutton','String','OK',...
	  'Units','normalized','Position',pos,...
	  'Callback','vb_plotparmdlg(''push_ok'')',...
	  'Parent',handle);

pos = [x+0.333*w y 0.333*w dh];
uicontrol('Style','pushbutton','String','Load ',...
	  'Units','normalized','Position',pos,...
	  'Callback','vb_plotparmdlg(''load_plot_parm'')',...
	  'Parent',handle);

pos = [x+0.666*w y 0.333*w dh];
uicontrol('Style','pushbutton','String','Save ',...
	  'Units','normalized','Position',pos,...
	  'Callback','vb_plotparmdlg(''save_plot_parm'')',...
	  'Parent',handle);

% Handles
plotparmdlg_variables.ed1 = ed1;
plotparmdlg_variables.ed2 = ed2;
plotparmdlg_variables.ed3 = ed3;
plotparmdlg_variables.ed4 = ed4;
plotparmdlg_variables.ed5 = ed5;
plotparmdlg_variables.ed6 = ed6;
plotparmdlg_variables.ed7 = ed7;
plotparmdlg_variables.ed8 = ed8;
plotparmdlg_variables.ed9 = ed9;
plotparmdlg_variables.ed10 = ed10;
plotparmdlg_variables.ed11 = ed11;
plotparmdlg_variables.ed12 = ed12;
plotparmdlg_variables.rb1 = rb1;
plotparmdlg_variables.rb2 = rb2;
plotparmdlg_variables.rb3 = rb3;
plotparmdlg_variables.rb4 = rb4;
plotparmdlg_variables.rb5 = rb5;
plotparmdlg_variables.rb6 = rb6;
plotparmdlg_variables.rb7 = rb7;

set_GUI_state;
previous_parm = get_GUI_state;

% Wait
uiwait(plotparmdlg_variables.h);

% Return new parameters
if ishandle(plotparmdlg_variables.h)
    plot_parm_new = get_GUI_state;
    close(handle);
else
    % close by x icon pushing.
    plot_parm_new = previous_parm;
end


%
% Initialize global variables
% 2004-03-16 Taku Yoshioka
%
function init_global_variables(plot_parm0)

global plotparmdlg_variables

plot_parm = vb_set_plot_parm;
f = fieldnames(plot_parm0);
for i = 1:length(f)
  plot_parm = setfield(plot_parm,f{i},getfield(plot_parm0,f{i}));
end

plotparmdlg_variables.plot_parm = plot_parm;

%
% Callback functions for radio buttons
% 2004-03-16 Taku Yoshioka
%
function change_cmap(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb1(i),'Value',1);
set(plotparmdlg_variables.rb1(2-i+1),'Value',0);

function change_light(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb4(i),'Value',1);
set(plotparmdlg_variables.rb4(2-i+1),'Value',0);

function change_display_mode(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb2(i),'Value',1);
set(plotparmdlg_variables.rb2(2-i+1),'Value',0);

function change_priority(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb3(i),'Value',1);
set(plotparmdlg_variables.rb3(2-i+1),'Value',0);

function change_paint(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb5(i),'Value',1);
set(plotparmdlg_variables.rb5(2-i+1),'Value',0);

function change_LR(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb6(1),'Value',0);
set(plotparmdlg_variables.rb6(2),'Value',0);
set(plotparmdlg_variables.rb6(3),'Value',0);
set(plotparmdlg_variables.rb6(i),'Value',1);

function change_normal_mode(i)

global plotparmdlg_variables;

set(plotparmdlg_variables.rb7(i),'Value',1);
set(plotparmdlg_variables.rb7(2-i+1),'Value',0);

%
% Resume from uiwait
% 2004-03-16 Taku Yoshioka
%
function push_ok

global plotparmdlg_variables;

uiresume(plotparmdlg_variables.h);

%
% Set state of GUI components
% 2004-04-02 Taku Yoshioka
%
function set_GUI_state

global plotparmdlg_variables;

plot_parm = plotparmdlg_variables.plot_parm;
ed1 = plotparmdlg_variables.ed1;
ed2 = plotparmdlg_variables.ed2;
ed3 = plotparmdlg_variables.ed3;
ed4 = plotparmdlg_variables.ed4;
ed5 = plotparmdlg_variables.ed5;
ed6 = plotparmdlg_variables.ed6;
ed7 = plotparmdlg_variables.ed7;
ed8 = plotparmdlg_variables.ed8;
ed9 = plotparmdlg_variables.ed9;
ed10 = plotparmdlg_variables.ed10;
ed11 = plotparmdlg_variables.ed11;
ed12 = plotparmdlg_variables.ed12;
rb1 = plotparmdlg_variables.rb1;
rb2 = plotparmdlg_variables.rb2;
rb3 = plotparmdlg_variables.rb3;
rb4 = plotparmdlg_variables.rb4;
rb5 = plotparmdlg_variables.rb5;
rb6 = plotparmdlg_variables.rb6;
rb7 = plotparmdlg_variables.rb7;

% Font size
set(ed1,'String',num2str(plot_parm.fs));

% Marker size
set(ed2,'String',num2str(plot_parm.ms));

% Line width
set(ed3,'String',num2str(plot_parm.lw));

% fMRI colormap
if plot_parm.cmap==1
  set(rb1(1),'Value',1);
  set(rb1(2),'Value',0);
else
  set(rb1(1),'Value',0);
  set(rb1(2),'Value',1);
end

% Lighting
if plot_parm.light==1
  set(rb4(1),'Value',1);
  set(rb4(2),'Value',0);
else
  set(rb4(1),'Value',0);
  set(rb4(2),'Value',1);
end

% Display mode
if plot_parm.wmode==1
  set(rb2(1),'Value',1);
  set(rb2(2),'Value',0);
else
  set(rb2(1),'Value',0);
  set(rb2(2),'Value',1);
end

% Max threshold
set(ed4,'String',num2str(plot_parm.wmax));

% Min threshold
set(ed5,'String',num2str(plot_parm.wmin));

% Normalization mode
if plot_parm.norm==1
  set(rb7(1),'Value',1);
  set(rb7(2),'Value',0);
else
  set(rb7(1),'Value',0);
  set(rb7(2),'Value',1);
end

% Angle
set(ed6,'String',num2str(plot_parm.angle(1)));
set(ed7,'String',num2str(plot_parm.angle(2)));

% Priority
if plot_parm.priority==1
  set(rb3(1),'Value',1);
  set(rb3(2),'Value',0);
else
  set(rb3(1),'Value',0);
  set(rb3(2),'Value',1);
end

% Rlabel
set(ed8,'String',num2str(plot_parm.Rlabel));

% zoom
set(ed9,'String',num2str(plot_parm.zoom));

% Paint mode
if plot_parm.paint==1
  set(rb5(1),'Value',1);
  set(rb5(2),'Value',0);
else
  set(rb5(1),'Value',0);
  set(rb5(2),'Value',1);
end

% LRflag
if strcmp(plot_parm.LRflag,'LR')
  set(rb6(1),'Value',1);
  set(rb6(2),'Value',0);
  set(rb6(3),'Value',0);
elseif strcmp(plot_parm.LRflag,'L')
  set(rb6(1),'Value',0);
  set(rb6(2),'Value',1);
  set(rb6(3),'Value',0);
else
  set(rb6(1),'Value',0);
  set(rb6(2),'Value',0);
  set(rb6(3),'Value',1);
end

% Print ratio/size
set(ed10,'String',num2str(plot_parm.print_ratio));
set(ed11,'String',num2str(plot_parm.print_size));

% Slice width
set(ed12,'String',num2str(plot_parm.width));

%
% Load plot parameters
% 2004-04-02 Taku Yoshioka
%
function load_plot_parm

global plotparmdlg_variables;

[pname,fname] = vb_file_select({'.plot.mat'});

if isempty(fname)
    % cancel
    return;
else
    fname = fname{1};
    load([pname filesep fname],'plot_parm');
    plotparmdlg_variables.plot_parm = plot_parm;
    set_GUI_state;
end

%
% Save plot parameters
% 2004-04-02 Taku Yoshioka
%
function save_plot_parm

[fname,pname] = uiputfile({'*.plot.mat';'Plot mat(*.plot.mat)'}, 'Save as', 'Untitled.plot.mat');
if (isnumeric(fname)) && (fname == 0)
    % cancel
    return;
else
    plot_parm = get_GUI_state; 
    vb_fsave([pname filesep fname],'plot_parm');
    msgbox('File saved.', 'msg')
end

%
% Get GUI state
% 2004-04-08 Taku Yoshioka
%
function plot_parm_new = get_GUI_state

global plotparmdlg_variables;

ed1 = plotparmdlg_variables.ed1;
ed2 = plotparmdlg_variables.ed2;
ed3 = plotparmdlg_variables.ed3;
ed4 = plotparmdlg_variables.ed4;
ed5 = plotparmdlg_variables.ed5;
ed6 = plotparmdlg_variables.ed6;
ed7 = plotparmdlg_variables.ed7;
ed8 = plotparmdlg_variables.ed8;
ed9 = plotparmdlg_variables.ed9;
ed10 = plotparmdlg_variables.ed10;
ed11 = plotparmdlg_variables.ed11;
ed12 = plotparmdlg_variables.ed12;
rb1 = plotparmdlg_variables.rb1;
rb2 = plotparmdlg_variables.rb2;
rb3 = plotparmdlg_variables.rb3;
rb4 = plotparmdlg_variables.rb4;
rb5 = plotparmdlg_variables.rb5;
rb6 = plotparmdlg_variables.rb6;
rb7 = plotparmdlg_variables.rb7;

plot_parm_new = vb_set_plot_parm; % default parameters

fs = str2num(get(ed1,'String'));
if isnumeric(fs) & fs>0 & fs<=100, 
  plot_parm_new.fs = fs; 
end

ms = str2num(get(ed2,'String'));
if isnumeric(ms) & ms>0 & ms<=100, 
  plot_parm_new.ms = ms; 
end

lw = str2num(get(ed3,'String'));
if isnumeric(lw) & lw>0 & lw<=100, 
  plot_parm_new.lw = lw; 
end

wmax = str2num(get(ed4,'String'));
if isnumeric(wmax) & wmax>0.0 & wmax<=1.0, 
  plot_parm_new.wmax = wmax; 
else
  wmax = plot_parm_new.wmax;
end

wmin = str2num(get(ed5,'String'));
if isnumeric(wmin) & wmin>0.0 & wmin<=wmax, 
  plot_parm_new.wmin = wmin; 
else
  plot_parm_new.wmin = 0.1*wmax;
end

angle1 = str2num(get(ed6,'String'));
if isnumeric(angle1)
  plot_parm_new.angle(1) = angle1;
end

angle2 = str2num(get(ed7,'String'));
if isnumeric(angle2)
  plot_parm_new.angle(2) = angle2;
end

Rlabel = str2num(get(ed8,'String'));
if isnumeric(Rlabel) & Rlabel>=1.0 & Rlabel<=4.0
  plot_parm_new.Rlabel = Rlabel;
end

z = str2num(get(ed9,'String'));
if isnumeric(z) & z>0 & z<=100.0
  plot_parm_new.zoom = z;
end

print_ratio = str2num(get(ed10,'String'));
if isnumeric(print_ratio) & print_ratio>0
  plot_parm_new.print_ratio = print_ratio; 
end

print_size = str2num(get(ed11,'String'));
if isnumeric(print_size) & print_size>0.0 
  plot_parm_new.print_size = print_size; 
end

width = ceil(str2num(get(ed12,'String')));
if isnumeric(width) & width>=0 
  plot_parm_new.width = width; 
end

if get(rb1(1),'Value')
  plot_parm_new.cmap = 1;
else
  plot_parm_new.cmap = 2;
end

if get(rb4(1),'Value')
  plot_parm_new.light = 1;
else
  plot_parm_new.light = 2;
end

if get(rb2(1),'Value')
  plot_parm_new.wmode = 1;
else
  plot_parm_new.wmode = 2;
end

if get(rb3(1),'Value')
  plot_parm_new.priority = 1;
else
  plot_parm_new.priority = 2;
end

if get(rb5(1),'Value')
  plot_parm_new.paint = 1;
else
  plot_parm_new.paint = 2;
end

if get(rb6(1),'Value')
  plot_parm_new.LRflag = 'LR';
elseif get(rb6(2),'Value')
  plot_parm_new.LRflag = 'L';
else
  plot_parm_new.LRflag = 'R';
end

if get(rb7(1),'Value')
  plot_parm_new.norm = 1;
else
  plot_parm_new.norm = 2;
end

% editable in this GUI in the future?
plot_parm_new.Jmax_ratio = plotparmdlg_variables.plot_parm.Jmax_ratio;
plot_parm_new.Jmin_ratio = plotparmdlg_variables.plot_parm.Jmin_ratio;
