function	vb_check_sphere(brainfile,megfile,Vradius)
% Check sphere model in 3D image
%  vb_check_sphere(brainfile, megfile, Vradius)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('Vradius','var') || isempty(Vradius)
	Vradius = 0.08; 
else 
	Vradius = Vradius; 
end

% Load sensor and sphere center position
[pick,Qpick,Wsensor,Vcenter] = vb_load_sensor(megfile);

% Load brain model
[V,F] = vb_load_cortex(brainfile, 'subj');
if ~isempty(F)
    F     = F.F3;
end

% Number of fig in subplot
NY		   = 2;	% Number of fig. in Y
NX		   = 2;	% Number of fig. in X

% plot color
fclr = [0.72 0.59 0.45];

% View angle definition 
vangle = [ 0  90; 90 0 ; 180 0 ; 0 0 ];
NV	   = size(vangle,1);

[sx,sy,sz]=sphere; 
sdim = size(sx);
sx = sx*Vradius + repmat(Vcenter(1),sdim); 
sy = sy*Vradius + repmat(Vcenter(2),sdim);
sz = sz*Vradius + repmat(Vcenter(3),sdim);

figure;

for n=1:NV
	subplot(NY,NX,n);

	% plot brain
    plot3(V(:, 1), V(:, 2), V(:, 3), '.', 'Color', fclr);
    hold on; 
    surf(sx,sy,sz);
   	view( vangle(n,:) ); 
	xlabel('X')
	ylabel('Y')
	zlabel('Z')
    alpha(0.2);
    axis equal;
    axis tight;
end

subplot(NY,NX,1);
title('Sphere model overlapped on brain model')

