function vb_check_head_plot(proj_root, head_parm, mode)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3, mode=0; end;

% Brain & image file for plot
brainfile   = head_parm.brain_file  ;
analyzefile = head_parm.analyze_file;

if iscell(head_parm.head_file)
	head_file = head_parm.head_file;
else
	head_file = {head_parm.head_file};
end

Nhead  = length(head_file);

% Head surface file name
for n=1:Nhead
	if isempty(proj_root)
		headfile  = [head_file{n}];
	else
		headfile  = [proj_root '/' head_file{n}];
	end
	if mode < 2
		headsave{n} = change_name(headfile, head_parm.Nvertex);
	else
		headsave{n} = headfile;
	end
end

switch	mode
case	{0,2}
	% --- Check 3 surface on MRI
	vb_plot_slice_head(headsave,analyzefile,brainfile);
	
	% --- head surface
	vb_plot_head_surf(headsave{1}, brainfile)
	
	vangle = [40 25 ; -130 10];
	
	view(vangle(2,:))
	alpha(0.9);
	
case	{1,3}
	for n=1:Nhead
		vb_plot_slice_head(headsave{n}, analyzefile, brainfile);
	end
end

if Nhead == 1, return; end;

figure;

if isfield(head_parm,'face_file') && ~isempty(head_parm.face_file), 
	load(head_parm.face_file)
	
	if exist('surf_face','var')
		if isfield(surf_face,'V_reduce')
			V = surf_face.V_reduce;
			F = surf_face.F_reduce;
		elseif isfield(surf_face,'V')
			V = surf_face.V;
			F = surf_face.F;
		end
	end
	
	vb_plot_surf(V,F,[],[],1,1);
	hold on
end

load(headsave{Nhead})
vb_plot_surf(Vhead,Fhead,'none','k');
alpha 0.9;

return
%
% --- change_name
%
function	fnew = change_name(fold, N);

fext = '.head.mat';
ix_ext = findstr(fold, fext);

if ~isempty(ix_ext),
	basename = fold(1:ix_ext-1);
else
	basename = fold;
end

fnew = sprintf('%s_%d%s', basename, N, fext);
