function [Basis_mode, pick, Qpick, Wsensor, V0, V, xx] = ...
  vb_lf_preprocess(proj_root, basis_parm)
% preprocess for making leadfield
% [usage]
%   [Basis_mode, pick, Qpick, Wsensor, V0, V, xx] = ...
%     vb_lf_preprocess(proj_root, basis_parm)
% [input]
%    proj_root : <required> project root directory
%   basis_parm : <required> <<struct>>
%              :  data set in which the specification of calculation is defined
% basis_parm.brain_file : brain file (.brain.mat)
% basis_parm.area_file  : area file  (.area.mat)
% basis_parm.meg_file   : MEG data file (.meg.mat)
% basis_parm.Basis_mode : number of independent curent direction
%       = 1 :  current vextor = xx(n,:)
%       = 2 :  current vextor = orthogonal vectors to V(n,:)
%       = 3 :  current vextor = xx(n,:) & orthogonal vectors to xx(n,:)
% basis_parm.normal_mode : 
%       = 0 : normal vector at the vertex (Defualt)
%       = 1 : average normal vector in the neighbor of BV original brain 
%
% basis_parm.area_key : Area key to specify possible current region <optional>
% [output]
%  V(n,:)  : dipole position (3-D coordinate) at n-th vertex
% xx(n,:)  : dipole current direction (unit vector) at n-th vertex
%  pick(k, 1:3) : sensor coil coordinate
% Qpick(k, 1:3)	: sensor coil direction
%
% Wsensor(m,n) = n-th coil weight for m-th sensor channel
%    basis(channel,dipole) = Wsensor * basis(coil,dipole)
%   Basis_mode : 
%           V0 : center of sphere
% [note]
%   <<prior-conditions>>
%     1) proj_root is valid
%     2) basis_parm is commonly valid
% [history]
%   2007-01-26 (Sako) initial version
%   2007-12-21 Masa-aki Sato
%              parameter checks are changed
%   2008-03-10 (Sako) modified in order to share check program with GUI
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

abort_swt = true;
[err_code, Basis_mode, pick, Qpick, Wsensor, V0, V, xx] = ...
  vb_basisparm_check(basis_parm, proj_root, abort_swt);
return;

%%% END OF FILE %%%
