function [grad, Itbl, Dim] = vb_spherical_grad_F(X, Q, N, Rmax)
% calculate gradient of spherical harmonics
% [usage]
%   [grad, ltbl, Dim] = vb_spherical_grad_F(X, Q, N, Rmax)
% [input]
%      X : coordinates of internal current (NP x 3)
%      Q : normal vector of internal current (NP x 3)
%      N : maximum order of spherical function
%   Rmax : radius
% [output]
%   grad : gradient F
%   ltbl : legendre index table
%    Dim : dimension
% [note]
%  
% [history]
%   2006.06.30 (Sako) initial version
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[F, Itbl, dim, Rmax] = vb_spherical_harmo_F(X,N,Rmax);

NP = size(F,1);
D  = (N+1)^2;

W1 = zeros(NP,1);
W2 = zeros(NP,1);

grad = zeros(NP,D);

for n = 0:N
  for m = 0:n
      
    n_idx = n + 1;
    m_idx = m + 1;

    if n_idx < 1 | n_idx > size(Itbl,1) | m_idx < 1 | m_idx > size(Itbl,2)
      continue;
    end
    
    % cosine zone
    column_num = Itbl(n_idx,m_idx,1);
    if column_num < 1, continue; end;
      
    % X
    [W1, valid1] = vb_spherical_harmo_W(n,m,F,Itbl,'+',0);
    [W2, valid2] = vb_spherical_harmo_W(n,m,F,Itbl,'-',0);
    x = 0.5 * (W1 + W2);
        
    % Y
    [W1, valid1] = vb_spherical_harmo_W(n,m,F,Itbl,'+',1);
    [W2, valid2] = vb_spherical_harmo_W(n,m,F,Itbl,'-',1);
    y = 0.5 * (W1 - W2);

    % Z
    [W1, valid] = vb_spherical_harmo_W(n,m,F,Itbl,'0',0);
    z = W1;

    grad(:,column_num) = x .* Q(:,1) + y .* Q(:,2) + z .* Q(:,3);

    % sine zone
    column_num = Itbl(n_idx,m_idx,2);
    if column_num < 1, continue; end;

    % X
    [W1, valid1] = vb_spherical_harmo_W(n,m,F,Itbl,'+',1);
    [W2, valid2] = vb_spherical_harmo_W(n,m,F,Itbl,'-',1);
    x = 0.5 * (W1 + W2);

    % Y
    [W1, valid1] = vb_spherical_harmo_W(n,m,F,Itbl,'+',0);
    [W2, valid2] = vb_spherical_harmo_W(n,m,F,Itbl,'-',0);
    y = 0.5 * (W2 - W1);

    % Z
    [W1, valid] = vb_spherical_harmo_W(n,m,F,Itbl,'0',1);
    z = W1;

    grad(:,column_num) = x .* Q(:,1) + y .* Q(:,2) + z .* Q(:,3);
    
  end
end

grad = grad(:,2:D);
Itbl = Itbl - 1;
Dim  = dim(:,2:D);
return;
