function [F_nm, validity] = vb_get_spherical_harmo(n,m,F,Itbl,c_s)
% return spherical harmonics value by using legendre index table
% [usage]
%   [ F_nm, validity ] = vb_get_spherical_harmo( n, m, F, Itbl, c_s)
% [input]
%          n : n value of spherical harmonics (n=1:N)
%          m : m value of spherical harmonics (m=0:n)
%          F : matrix of value of spherical harmonics
%       ltbl : index table of legendre
%        c_s : cosine(0) or sine(1)
% [output]
%       F_nm : (n,m)element of matrix F
%   validity : validity of F_nm. valid(true) or invalid(false)
% [note]
% 
% [history]
%   2006.08.24 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% temporary value
validity   = false;
column_num = 0;

F_nm = zeros(size(F,1),1);

% convert from legendre number to matrix index
IdxNN = n + 1;

if m >= 0, 
	IdxMM = m + 1;
else
	IdxMM = -m + 1;
end

if n < m, 
	return
end
if IdxNN < 1 | IdxNN > size(Itbl,1) | IdxMM < 1 | IdxMM > size(Itbl,2)
	return
end

if  c_s == 0    % cosine
	column_num = Itbl(IdxNN,IdxMM,1);
	
	if column_num < 1, return; end;
	
	if m >= 0, 
		F_nm = F(:,column_num);
	else
		% Normalized Legendre function case
		F_nm = -F(:,column_num);
	end
elseif c_s == 1 % sine
	column_num = Itbl(IdxNN,IdxMM,2);
	
	if column_num < 1, return; end;

	if m >= 0, 
		F_nm = F(:,column_num);
	else
		% Normalized Legendre function case
		F_nm = F(:,column_num);
	end
end

validity = true;
return

