function R_ave = vb_average_radius(center, satellites)
% return average distance between center point and satellites
% [usage]
%   R_ave = vb_average_radius( center, satellites )
% [input]
%       center : coordinate of center point (1 x 3)
%   satellites : points like coordinates of sensors (NP x 3)
% [output]
%   R_ave : calculated average distance
% [note]
% 
% [history]
%   2006.07.12 (Sako) initial version
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NP = size(satellites,1);
c_rep = repmat(center, NP,1);
R_ave = sum(sqrt(sum(((satellites - c_rep) .^ 2),2))) ./ NP;

return;
