function [V, xx, pick, Qpick, Wsensor, BEM, Vhead, Fhead, ...
         Omega, Sout, SPHinfo] = vb_prepare_lead_field(basis_parm)
%  Prepare leadfieled calculation
%  [V, xx, pick, Qpick, Wsensor, BEM, Vhead, Fhead, Omega, Sout, SPHinfo] = ...
%         vb_prepare_lead_field(basis_parm)
% --- Input
% basis_parm.brain_file : brain file (.brain.mat)
% basis_parm.area_file  : area file  (.area.mat)
% basis_parm.meg_file   : MEG data file (.meg.mat)
% basis_parm.Basis_mode : number of independent curent direction
%       = 1 :  current vextor = xx(n,:)
%       = 2 :  current vextor = orthogonal vectors to V(n,:)
%       = 3 :  current vextor = xx(n,:) & orthogonal vectors to xx(n,:)
% basis_parm.bem_mode   : Leadfield calculation method
%   MEG
%      0  : MEG spherical model (Sarvas)
%      1  : MEG BEM 1 shell model
%      2  : MEG spherical harmonics expansion
%   EEG
%      3  : EEG spherical 3 shell model
%      4  : EEG BEM 3 shell model
%
% --- Optional Input
% basis_parm.normal_mode : 
%       = 0 : normal vector at the vertex (Defualt)
%       = 1 : average normal vector in the neighbor of BV original brain 
%
% basis_parm.head_file     : Head surface file (.head.mat)
% basis_parm.area_key      : Area key to specify possible current region
% basis_parm.func_order    : Order of spherical harmonics function
% basis_parm.Recalc        : Recalculation force flag
% basis_parm.sigma         : Conductivity of each region
% basis_parm.radius        : Relative radius of sphere
% basis_parm.radius_method : priority of radius. mainly for 3-shell model.
%                          : 'basis_parm' or 'head_mean' or 'head_max'
%                          : 'basis_parm' : basis_parm.radius
%                          :  'head_mean' : mean distance of each head
%                          :   'head_max' : maximum distance of each head
% --- Output
%  V(n,:)  : dipole position (3-D coordinate) at n-th vertex
% xx(n,:)  : dipole current direction (unit vector) at n-th vertex
%  pick(k, 1:3) : sensor coil coordinate
% Qpick(k, 1:3)	: sensor coil direction
%
% Wsensor(m,n) = n-th coil weight for m-th sensor channel
%    basis(channel,dipole) = Wsensor * basis(coil,dipole)
%
%   BEM      : BEM parameters
%   Vhead    : Head surface coordinate
%   Fhead    : Head surface patch index
%   Sout     : Head surface normal direction
%   Omega    : Solid angle matrix
%  SPHinfo   : Parameters for Spherical Harmonics
% 
% new version 2005-8-10 M. Sato
% 2006-7-23 M. Sato
%   basis_parm.normal_mode is added for soft normal constraint
% modified by Sako 2006-07-28
% modified by M. Sato 2006-08-24
% modified by Sako 2006-12-04 : for EEG 3-shell head model
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Set parameters
vb_struct2vars(basis_parm,{'bem_mode','Basis_mode','area_key','proj_root'});

% Basis mode definition
global vbmeg_inst;
const = vbmeg_inst.const;
% const.BASIS_MEG_SPHERE;   %  MEG Sphere model (Sarvas)
% const.BASIS_MEG_BEM;      %  MEG BEM
% const.BASIS_MEG_HARMONICS;%  MEG Spherical harmonics expansion
% const.BASIS_EEG_SPHERE;   %  EEG 3-shell Sphere model
% const.BASIS_EEG_BEM;      %  EEG 3-shell BEM

% Check optional parameter
if isfield(basis_parm,'normal_mode')
	normal_mode = basis_parm.normal_mode;
else
 	normal_mode = const.NORMAL_ADJACENT_MEAN;
end

if ~isfield(basis_parm,'Recalc'),
	% Recalculation force flag
	basis_parm.Recalc = OFF;
end

if ~isfield(basis_parm, 'func_order'),
	% Order of spherical harmonics function
	basis_parm.func_order = 35;
end

if ~isfield(basis_parm,'DEBUG'),
	basis_parm.DEBUG = OFF;
end

brain_file = [proj_root filesep basis_parm.brain_file];
area_file  = [proj_root filesep basis_parm.area_file ];
meg_file   = [proj_root filesep basis_parm.meg_file];

% Load sensor info
[pick,Qpick,Wsensor,V0] = vb_load_sensor(meg_file);

% Load cortical vertex coordinate and normal vector
[V ,xx] = vb_load_cortex_area(brain_file,area_file,area_key,normal_mode);

switch	bem_mode
case	{const.BASIS_MEG_SPHERE}
% case	{const.BASIS_MEG_SPHERE, const.BASIS_EEG_SPHERE}
	% Change center of coordinate
	pick = [pick(:,1)-V0(1), pick(:,2)-V0(2), pick(:,3)-V0(3)];
	V    = [   V(:,1)-V0(1),    V(:,2)-V0(2),    V(:,3)-V0(3)];
	
case	const.BASIS_MEG_HARMONICS, 
	% Load head file
	head_file   = [proj_root filesep basis_parm.head_file];
	load([head_file], 'Vhead');
	
	% Center of Head
	if basis_parm.DEBUG == ON,
		% Setting for DEBUG to check Leadfield calculation
		Hcenter = [0 0 0];
	else
		Hcenter = mean(Vhead);
	end
	
	% Change center of coordinate
	Vhead = [Vhead(:,1)-Hcenter(1),  ...
	         Vhead(:,2)-Hcenter(2), Vhead(:,3)-Hcenter(3)];
	V     = [    V(:,1)-Hcenter(1),  ...
	             V(:,2)-Hcenter(2),     V(:,3)-Hcenter(3)];
	pick  = [ pick(:,1)-Hcenter(1),   ...
	          pick(:,2)-Hcenter(2),  pick(:,3)-Hcenter(3)];
        
  case const.BASIS_EEG_SPHERE
  	pick = [pick(:,1)-V0(1), pick(:,2)-V0(2), pick(:,3)-V0(3)];
  	V    = [   V(:,1)-V0(1),    V(:,2)-V0(2),    V(:,3)-V0(3)];
    basis_parm = vb_util_check_head_shell_info(basis_parm);    
    
  case  const.BASIS_EEG_BEM
    basis_parm = vb_util_check_head_shell_info(basis_parm);    
end

% Calculate current direction according to 'Basis_mode'
[V,xx] = vb_current_vector(V, xx, Basis_mode);

% Prepare BEM parameter and calculate solid angle matrix
[BEM, Vhead, Fhead, Omega, Sout, SPHinfo] = vb_prepare_bem(basis_parm);

