function [calcmode] = vb_util_convert_rmethod2calcmode(rmethod)
% convert Rmethod (string) to calc_mode (numeric)
% [usage]
%   [calcmode] = vb_util_convert_rmethod2calcmode(rmethod)
% [input]
%   rmethod : <required> Rmethod string as follow
%           :  'MEAN' or 'MIN' or 'MAX'
% [output]
%   calcmode : calculation mode
%            :  'MEAN' --> 1
%            :  'MIN' ---> 2
%            :  'MAX' ---> 3
%            :  'USER' --> 4
%            :  unknown -> 0
% [note]
%   case-insensitive
% [history]
%   2007-06-15 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('rmethod', 'var') rmethod = []; end
[rmethod] = inner_check_arguments(rmethod);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% constants
func_ = 'vb_util_convert_rmethod2calcmode';

METHOD(1).name = 'MEAN'; METHOD(1).code = 1;
METHOD(2).name = 'MIN';  METHOD(2).code = 2;
METHOD(3).name = 'MAX';  METHOD(3).code = 3;
METHOD(4).name = 'USER'; METHOD(4).code = 4;

% unknown method
UNKNOWN_METHOD = 0;

for im = 1:size(METHOD,2)
  if strcmp(rmethod, METHOD(im).name)
    calcmode = METHOD(im).code;
    return;
  end
end
calcmode = UNKNOWN_METHOD;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [rmethod] = inner_check_arguments(rmethod)
func_ = 'vb_util_convert_rmethod2calcmode';
if isempty(rmethod)
  error('(%s)rmethod is a required parameter', func_);
end

% case-insensitive
rmethod = upper(rmethod);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
