function Headinfo = vb_headinfo_set_sigma(headinfo, sigma)
% setter Headinfo.Sigma
% [usage]
%   Headinfo = vb_headinfo_set_sigma(headinfo, sigma)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%      sigma : <optional> value of Sigma
%            :  if it is not specified or is empty, [] will be set
% [output]
%    Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('sigma', 'var')    sigma = []; end;
[Headinfo, sigma] = inner_check_arguments(headinfo, sigma);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.Sigma = sigma;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, sigma] = inner_check_arguments(headinfo, sigma)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
