function vb_headinfo_save(Headinfo, head_file)
% save <Headinfo> to <head_file>
% [usage]
%   vb_headinfo_save(Headinfo, head_file)
% [input]
%   Headinfo : <required> <<struct>>
%   head_file : <required> file name that you want to save
% [output]
%   none
% [note]
%   Not all fields of Headinfo are stored to head-mat file
%   @see vb_out_normal.m
% [history]
%   2007-04-06 (Sako) initial version
%   2007-06-14 (Sako) remove some fields from head-mat file
%   2010-10-25 (Sako) if XXhead is empty, calculate it before making file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('Headinfo', 'var'), Headinfo = []; end;
if ~exist('head_file', 'var'), head_file = []; end;
[Headinfo, head_file] = inner_check_arguments(Headinfo, head_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% existing each fields are guaranteed in inner_check_arguments()
Vhead    = Headinfo.Vhead;
Fhead    = Headinfo.Fhead;
XXhead   = Headinfo.XXhead;
Sigma    = Headinfo.Sigma;
LayerTag = Headinfo.LayerTag;
Rmethod  = Headinfo.Rmethod;
R        = Headinfo.R;
Npatch   = Headinfo.Npatch;
Nvertex  = Headinfo.Nvertex;

% support empty XXhead
if isempty(XXhead)
  if ~isempty(Vhead) && ~isempty(Fhead)
    if ~isempty(Nvertex) && ~isempty(Npatch)
      n_layer = size(Nvertex,1);

      prev_point = 0;
      for i_layer = 1:n_layer
        % if plural layer model, calculate each layer
        f_begin = Npatch(i_layer,1);
        f_end   = Npatch(i_layer,2);
        v_begin = Nvertex(i_layer,1);
        v_end   = Nvertex(i_layer,2);
        
        cur_v = Vhead(v_begin:v_end,:);
        cur_f = Fhead(f_begin:f_end,:) - prev_point;
        [new_f, new_v, cur_XX] = vb_out_normal(cur_f, cur_v);
        XXhead = [XXhead; cur_XX];
        prev_point = prev_point + size(cur_v,1);
      end
    else
      [new_f, new_v, XXhead] = vb_out_normal(Fhead, Vhead);
    end
  else
    if isempty(Vhead), warning('Vhead is empty'); end
    if isempty(Fhead), warning('Fhead is empty'); end
    warning('XXhead is empty');
  end
end

% --- 20070615 removed Sigma, Rmethod, R
%
% vb_save(head_file, 'Vhead', 'Fhead', 'XXhead', 'Sigma', 'LayerTag', ...
%   'Rmethod', 'R', 'Npatch', 'Nvertex' );
vb_save(head_file, 'Vhead','Fhead','XXhead','Npatch','Nvertex','LayerTag');
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [Headinfo, head_file] = inner_check_arguments(Headinfo, head_file)
if isempty(Headinfo)
  error('Headinfo is a required parameter');
end

if isempty(head_file)
  error('head_file is a required parameter');
end

if ~isfield(Headinfo, 'Vhead')    Headinfo.Vhead = []; end;
if ~isfield(Headinfo, 'Fhead')    Headinfo.Fhead = []; end;
if ~isfield(Headinfo, 'XXhead')   Headinfo.XXhead = []; end;
if ~isfield(Headinfo, 'Sigma')    Headinfo.Sigma = []; end;
if ~isfield(Headinfo, 'LayerTag') Headinfo.LayerTag = []; end;
if ~isfield(Headinfo, 'Rmethod')  Headinfo.Rmethod = []; end;
if ~isfield(Headinfo, 'R')        Headinfo.R = []; end;
if ~isfield(Headinfo, 'Npatch')   Headinfo.Npatch = []; end;
if ~isfield(Headinfo, 'Nvertex')  Headinfo.Nvertex = []; end;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
