function npatch = vb_headinfo_get_npatch(Headinfo)
% getter of Headinfo.Npatch
% [usage]
%   npatch = vb_headinfo_get_npatch(Headinfo)
% [input]
%   Headinfo : <required> <<struct>>
%            :  if this does not have target field, return empty ([]).
% [output]
%      npatch : Headinfo.Npatch
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('Headinfo', 'var') Headinfo = []; end;
[Headinfo] = inner_check_arguments(Headinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
npatch = Headinfo.Npatch;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [Headinfo] = inner_check_arguments(Headinfo)
if isempty(Headinfo)
  error('Headinfo is a required parameter');
end

if ~isfield(Headinfo, 'Npatch') Headinfo.Npatch = []; end;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
