function layer_tag = vb_headinfo_get_layertag(Headinfo)
% getter of Headinfo.LayerTag
% [usage]
%   layer_tag = headinfo_get_layer_tag(Headinfo)
% [input]
%   Headinfo : <required> <<struct>>
%            :  if this does not have target field, return empty ([]).
% [output]
%      layer_tag : Headinfo.LayerTag
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('Headinfo', 'var') Headinfo = []; end;
[Headinfo] = inner_check_arguments(Headinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
layer_tag = Headinfo.LayerTag;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [Headinfo] = inner_check_arguments(Headinfo)
if isempty(Headinfo)
  error('Headinfo is a required parameter');
end

if ~isfield(Headinfo, 'LayerTag') Headinfo.LayerTag = []; end;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
