function [retval] = vb_head_load_vhead(head_file)
% Vhead loader from head file
% [usage]
%   [retval] = vb_head_load_vhead(head_file)
% [input]
%   head_file : <required> head file (accessible path)
% [output]
%      retval : loaded data
% [note]
%   if cannot find Vhead field, return empty
% [history]
%   2007-04-10 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('head_file', 'var') head_file = []; end;
[head_file] = inner_check_arguments(head_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
retval = [];
load(head_file, 'Vhead');
if exist('Vhead', 'var')
  retval = Vhead;
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [head_file] = inner_check_arguments(head_file)
if isempty(head_file)
  error('head_file is a required parameter');
end

if exist(head_file, 'file') ~= 2
  error('cannot read head_file : %s', head_file);
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
