function layer_num = vb_head_get_layer_num(head_file)
% return number of layer by reading head-mat file
% [usage]
%   layer_num = vb_head_get_layer_num(head_file)
% [input]
%   head_file : <required> head-mat file
% [output]
%   layer_num : number of layer
% [note]
% 
% [history]
%   2007-04-17 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('head_file', 'var') head_file = []; end;
[head_file] = inner_check_arguments(head_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
head = load(head_file);
layer_num = vb_headinfo_get_layer_num(head);
% if isfield(head, 'Npatch') && size(head.Npatch, 1) > 1
%   layer_num = size(head.Npatch, 1);
% else
%   layer_num = 1;
% end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [head_file] = inner_check_arguments(head_file)
if isempty(head_file)
  error('head_file is a required parameter');
end

if exist(head_file, 'file') ~= 2
  error('cannot read head_file : %s', head_file);
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
