function P = vb_bem_eeg_linear_grk(Peeg,Vs,Fs,V,J)
% EEG potencial for multilayer model
%  P = vb_bem_eeg_linear_grk(Peeg,Vs,Fs,V,J)
% OUTPUTS:
%  P : EEG Lead field matrix   ( M x NP)
%  P : ¿إǥEEG 󥵥ݥƥ󥷥
%
% INPUTS (Required):
%   V   : dipole location(in meters)               NP x 3
%   J   : dipole moment                            NP x 3
% Vs : vertex coordinate for boundary surfaces  [Nvertex x 3]
% Fs : patch index for boundary surfaces [Npatch x 3]
% Peeg : transform matrix to map surface potencial to EEG [Nsensor x Nvertex]
%
% Peeg : ĺ
% Vs : ̤κɸ
% Fs : ĺǥå
% V    : ήж˻Һɸ        (m)
% J    : ήж˻ҥ⡼
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% P0    : ĺΥݥƥ󥷥     (Nvertex,Ndipole)

Nskip = 100;
NSKIP = 1000;

%  ѿμ
NJ = size(V,1);		% ήж˻
NF = size(Fs,1);	% 
NV = size(Vs,1);    % ĺ
NS = size(Peeg,1);	% EEG 

%  ݥƥ󥷥
P0 = zeros(NV,1);
P  = zeros(NS,NJ);  % ̾Υݥƥ󥷥

% ̤ĺtriangle vertex
x1 = Vs(Fs(:,1),:);
x2 = Vs(Fs(:,2),:);
x3 = Vs(Fs(:,3),:);

% ̤
s0 = vb_cross2(x2-x1,x3-x1);
S = sqrt(sum(s0.^2,2));

%%%% ¬ǤΥݥƥ󥷥׻ %%%

% ̤
ip1 = (4*x1+x2+x3)/6; 
ip2 = (x1+4*x2+x3)/6; 
ip3 = (x1+x2+4*x3)/6;

for n=1:NJ,
  % n-ܤж˻
  x0 = V(n,:);
  J0 = J(n,:);
  
  % ж˻ҥݥƥ󥷥 
  p1 = vb_dipole_pot(J0,x0,ip1);
  p2 = vb_dipole_pot(J0,x0,ip2);
  p3 = vb_dipole_pot(J0,x0,ip3);
  
  P0 = zeros(NV,1);

  for i = 1:NF
    ix1 = Fs(i,1);
    ix2 = Fs(i,2);
    ix3 = Fs(i,3);
    P0(ix1) = P0(ix1)+S(i)/36*(4*p1(i)+p2(i)+p3(i));
    P0(ix2) = P0(ix2)+S(i)/36*(p1(i)+4*p2(i)+p3(i));
    P0(ix3) = P0(ix3)+S(i)/36*(p1(i)+p2(i)+4*p3(i));
  end

  % ̥ݥƥ󥷥
  P(:,n) = Peeg*P0;

  if mod(n,Nskip)==0, fprintf('-'); end;
  if mod(n,NSKIP)==0, fprintf(' %3.0f %% done\n', 100*n/NJ); end;
end;
