function vb_job_meg(varargin)
% Import M/EEG data and create MEG-MAT (.meg.mat) or EEG-MAT (.eeg.mat) file. 
% (VBMEG public function)
%
% This function is available for 
%  MEG data : Yokogawa
%  EEG data : BIOSEMI, BRAINAMP
%
% [syntax]
% vb_job_meg(meg_parm)
% vb_job_meg(proj_root, meg_parm)    [old style]
%
% [input]
% proj_root: <<string>> VBMEG project root directory.
% meg_parm : <<struct>> Depend on the measurement data to be imported. 
%                       @see vb_set_yokogawa_meg_parm.m
%                       @see vb_set_meg_parm_biosemi.m
%                       @see vb_set_meg_parm_brainamp.m
%
% --- fields for Yokogawa MEG data
%  Measurement  : <required> 'MEG'
%  device       : <required> 'YOKOGAWA'
%  yokogawa_file: <required> Filename of Yokogawa MEG data.
%               :  Raw (.raw), continuous (.con), and averaged (.ave)
%               :  are supported. 
%  meg_file     : <required> VBMEG MEG file (.meg.mat) that will be made.
%               :  This field must include the full extension.
%               :  MEG : ".meg.mat"
%               :  EEG : ".eeg.mat"
%  pos_file     : <optional> Sensor position file (.pos.mat). 
%  memory_max   : <optional> Maximum memory size in one loading data from 
%               :  yokogawa file. To calculate block size with the number of
%               :  channel. [const.DEFAULT_MEMORY_MAX (=10M)]
%               :  @see vb_meg_yokogawa_make_data.m
%               :  @see vb_define_yokogawa.m
%  ex_ch_gain   : <optional> This is applied for amplitude of external signals. 
%
% [output]
%   none
%
% [note]
%   VBMEG MEG(.meg.mat)/EEG(.eeg.mat) file is created.
%
% [history]
%   2008-02-13 (Sako) support EEG
%   2010-05-30 Taku Yoshioka
%     Minor change (verbose level support)
%   2011-02-17 (Sako) rewrote help in accordance with the latest specification
%   2014-08-06 (rhayashi) supported BRAINAMP data import.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if length(varargin) == 1
  proj_root = [];
  meg_parm = varargin{1};
elseif length(varargin) == 2
  proj_root = varargin{1};
  meg_parm = varargin{2};
end

proj_root = vb_rm_trailing_slash(proj_root);

% --- CHECK DEVICE --- %
[Measurement, Device] = vb_meg_parm_get_measurement(meg_parm);

if isempty(Measurement) || isempty(Device)
  vb_disp_nonl(sprintf('(%s) Measurement and device', mfilename));
  vb_disp(sprintf(' are required parameters of meg_parm'));
  vb_disp(sprintf('(%s) Please check meg_parm', mfilename));
  return;
else
  Measurement = upper(Measurement);
  Device = upper(Device);
end    

% --- MEG --- %
switch Measurement
  case 'MEG'
    switch Device
      case 'YOKOGAWA'
        vb_meg_yokogawa_make_data(proj_root, meg_parm);
      otherwise
        make_sbi_meg_data(proj_root, meg_parm);
    end
    
  case 'EEG'
    switch Device
      case {'BIOSEMI', 'BRAINAMP'}
        vb_job_eeg_gateway(proj_root, meg_parm);
      otherwise
        error('(%s)unexpected Device : %s', func_, Measurement);
    end
  otherwise
    error('(%s)unexpected Measurement : %s', func_, Measurement);
end

% project_file save
proj_file = get_project_filename;
if isempty(proj_file)
  return;
end

project_file_mgr('load', proj_file);
project_file_mgr('add', 'meg_parm', meg_parm);
return;
%%% END OF FILE %%%
