function [func_name] = vb_judge_function_name(parm, parm_type)
% Check parameter and return its job function
% [USAGE]
%    [func_name] = vb_judge_function_name(parm, parm_type);
% [IN]
%         parm : parameter
%    parm_type : parameter type string (ex. 'brain_parm', 'head_parm')
% [OUT]
%    func_name : function name(string)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%

if ~exist('parm', 'var')
    error('parm is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%

func_name = 'unknown';

if isfield(parm, 'caller_function')
    caller_function = parm.caller_function;
    if ~isempty(caller_function) && ischar(caller_function) && ...
       ~isempty(which(caller_function))
        func_name = caller_function;
        return;
    end
end

% if parm field doesn't have a caller function field,
% function name is judged here.
switch(parm_type)
    case 'brain_parm'
        if isfield(parm, 'subj_mask')
            func_name = 'vb_job_brain_std2sbj';
        elseif isfield(parm, 'std_brain')
            func_name = 'vb_job_brain_model_std2sbj';
        elseif isfield(parm, 'brain_sphL') && isfield(parm, 'brain_sphR')
            func_name = 'vb_job_brain_add_sphcoord';
        elseif isfield(parm, 'vstep')
            func_name = 'vb_job_smooth_cortex';
        else
            func_name = 'vb_job_brain';
        end
    case 'fmri_parm'
        func_name = 'vb_job_fmri';
    case 'basis_parm'
        func_name = 'vb_job_leadfield';
    case 'bayes_parm'
        func_name = 'vb_job_vb';
    case 'current_parm'
        if isfield(parm, 'filterfile')
            func_name = 'vb_job_current_feature';
        else
            func_name = 'vb_job_current';
        end
    case 'meg_parm'
        func_name = 'vb_job_meg';
    case 'head_parm'
        func_name = 'vb_job_head_3shell';
    case 'coreg_parm'
        func_name = 'vb_job_coreg_brain';
    case 'avr_parm'
        %func_name = 'vb_job_grandaverage'; % not supported yet 2011/01/28
    case 'tf_parm'
        %func_name = 'unknown'; % not supported yet 2011/01/28
    case 'mkdir_parm'
        func_name = 'vb_batch_job_mkdir';
end
