function [Vindx ,V, F] = vb_job_reduced_cortex(proj_root,brain_parm);
% Make reduced cortex without corpus region
%  vb_job_reduced_cortex(proj_root,brain_parm);
% --- Optional input
% brain_parm.reduce_brain : reduced ratio
% brain_parm.R_normal : Max radius of neighbor search
% --- Output
% The following area is saved to original brain area_file
% areakey = 'reduced_cortex' : reduced cortex without corpus region
% 
% Reduced brain file is also saved
%  'F','V','xx', ...
% normal_stat.neighbor_org : BV original brain neighbor for specified vertex
% normal_stat.normal_org   : BV original brain normal vector
% 
% original_info.parent_ix   = original vertex index for 'reduced_cortex'
% original_info.neighbor_ix = original neighbor index  for 'reduced_cortex'
% 
% M. Sato 2006-7-21
% 2008-12-24 Taku Yoshioka
%  vb_disp() is used for displaying message
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

proj_root = vb_rm_trailing_slash(proj_root);

const = vb_define_verbose;
VERBOSE_LEVEL_NOTICE = const.VERBOSE_LEVEL_NOTICE;

% switch flag to plot resulted reduced cortex 
plot_mode = 1;

brain_file = [proj_root filesep brain_parm.brain_file];
area_file  = [proj_root filesep brain_parm.area_file ];
act_file   = [proj_root filesep brain_parm.act_file  ];

% ID for MRI image data
[udir, fname] = fileparts(brain_parm.analyze_file);
MRI_ID = fname;

% Reduce ratio
if isfield(brain_parm,'reduce_brain')
	reduce_brain = brain_parm.reduce_brain; 
else
	reduce_brain = 1/3;	
end

% Max radius of neighbor search
if isfield(brain_parm,'R_normal')
	Rmax = brain_parm.R_normal; 
else
	Rmax = 0.004;	% 4mm
end

%
% --- Make reduced brain
%
tic
vb_disp('Make reduced cortex', VERBOSE_LEVEL_NOTICE);
Vindx = [];
[Vindx ,V, F, xx, Vinfo] = vb_reduce_cortex(brain_file,Vindx,reduce_brain);
vb_ptime(toc)

% Add 'reduced_cortex' area to original areafile
area_key    = 'reduced_cortex';
AreaNew.key = area_key;
AreaNew.Iextract = Vindx(:);
vb_add_area(area_file,AreaNew,[],OFF);

%
% --- Search next-point index and distance
%
tic;
vb_disp_nonl('Search next-point index and distance: ', VERBOSE_LEVEL_NOTICE);

[xxD, xxF, xxT] = vb_next_distance( F.F3, V ); % unit : m

vb_disp(sprintf('%f[sec]',toc), VERBOSE_LEVEL_NOTICE);

%
% --- Calculate area assigned to the vertex
%
tic

[xxA] = vb_calc_patch_area(V, F.F3, xxT);

vb_disp(sprintf('%f[sec]',toc), VERBOSE_LEVEL_NOTICE);

%
% --- Generate the neighbor information of reduced cortex
%
[nextDD, nextIX] = vb_load_cortex_neighbour(brain_file) ;
[nextIX, nextDD] = vb_reduce_neighbor_data(Vindx,nextIX,nextDD);

% make new file name
add_name   = '_reduce';
brain_file2 = vb_change_file_basename(brain_file,add_name);
area_file2  = vb_change_file_basename(area_file,add_name);
act_file2   = vb_change_file_basename(act_file,add_name);

vb_disp('Save brain model ', VERBOSE_LEVEL_NOTICE);
vb_disp(sprintf('     filename = %s', brain_file2), ...
        VERBOSE_LEVEL_NOTICE);

vb_save([brain_file2], 'F','V','xx','xxF','xxD','xxA', ...
     'Vinfo','nextIX','nextDD','MRI_ID');

% total number of vertex
Ndipole = size(V,1);

% Make activity map file
act_new.key     = 'Uniform';
act_new.xxP     = ones(Ndipole,1);
act_new.comment = 'artificial data';

vb_add_act([act_file2], act_new, MRI_ID, OFF);

% Make Area file
AreaNew.key      = 'Cortex';
AreaNew.Iextract = [1:Ndipole]'; 

vb_add_area([area_file2], AreaNew, MRI_ID, OFF);

if plot_mode == 1,
	
	% View angle
	angle = [45 30; -45 30];
	
	figure;
	subplot(1,2,1)
	vb_plot_surf(V, F.F3L, [],'k', 1, 1);
	view(angle(1,:));
	title('Reduced left brain')
	
	subplot(1,2,2)
	vb_plot_surf(V, F.F3R, [],'k', 1, 1);
	view(angle(2,:));
	title('Reduced right brain')
end

%
% --- Normal statuctics
%
vb_disp('Find normal statics in brain file', VERBOSE_LEVEL_NOTICE);

[normal_stat , original_info] = ...
          vb_cortex_normal_statics(brain_file,area_file,area_key,Rmax);

original_info.brain_file = brain_parm.brain_file;

%
% --- Save reduced brain model
%
vb_disp('Save normal statics ', VERBOSE_LEVEL_NOTICE);

vb_save([brain_file2], 'original_info','normal_stat');
