function vb_job_plot_verdist(brainfile)
% Plots histogram of the distance between nearest vertices. 
%
% Usage
% - vb_job_plot_verdist(brainfile)
%
% Input parameters
% - brainfile: VBMEG brain file (.brain.mat)
%
% Input parameters (optional)
%
% Output parameters
%
% Example
% >> brainfile = './TY/data/TY.brain.mat';
% >> vb_job_plot_verdist(brainfile);
%
% History
% - 2006-08-11 Taku Yoshioka
% 2011-06-20 taku-y
%  [minor] Progress message was added. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(brainfile,'xxD');

k = 0;
for i=1:length(xxD)
  k = k+length(xxD{i});
end

data = zeros(k,1);
k = 1;
h = waitbar(0,'Distance data collection');
prg     = 0;
prg_all = length(xxD);
vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));

for i=1:length(xxD)
  for j=1:length(xxD{i})
    data(k) = xxD{i}(j)*1000;
    k = k+1;
  end
  
  waitbar(i/length(xxD),h);
  for ii=1:15; vb_disp_nonl(sprintf('\b')); end
  vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
  prg = prg+1;
end

close(h);
vb_disp_nonl(sprintf('\n'));

hist(data,40);
xlabel('Distance between nearest vertices [mm]');
ylabel('Frequency');

return;