function vb_act_area_viewer(brain_file, varargin)
% Launch viewer of cortical activity/area.
% [Usage]
%    vb_act_area_viewer;
%    vb_act_area_viewer(brain_file);
%    vb_act_area_viewer(brain_file, act_file, area_file);
%    vb_act_area_viewer(brain_file, area_file, act_file);
%    vb_act_area_viewer(brain_file, act_file);
%    vb_act_area_viewer(brain_file, area_file);
%
% [Input]
%    brain_file : Cortical model file(.brain.mat)
%      act_file : Cortical activity file(.act.mat)
%     area_file : Cortical area file(.area.mat)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
e = vb_define_extension;
Nargs = nargin-1;
if Nargs >= 1
    for k=1:Nargs
        input = varargin{k};
        if strfind(input, e.AREA_EXTENSION)
            area_file = input;
        elseif strfind(input, e.FMRI_EXTENSION)
            act_file = input;
        elseif isempty(input)
        else
            error('Unknown input. Please check function usage');
        end
    end
end

if ~exist('brain_file', 'var')
    brain_file = '';
end
if ~exist('act_file', 'var')
    act_file = '';
end
if ~exist('area_file', 'var')
    area_file = '';
end

%
% --- Main procedure
%
brain_exist = exist(brain_file, 'file');
act_exist = exist(act_file, 'file');
area_exist = exist(area_file,  'file');

if brain_exist && act_exist && area_exist
    % brain + area + act
    job_view_cortex_init(brain_file, '--area', area_file, '--act', act_file);
elseif brain_exist && ~act_exist && ~area_exist
    % brain
    job_view_cortex_init(brain_file);
elseif brain_exist && area_exist && ~act_exist
    % brain + area
    job_view_cortex_init(brain_file, '--area', area_file);
elseif brain_exist && act_exist && ~area_exist
    % brain + act
    job_view_cortex_init(brain_file, '--act', act_file);
else
    job_view_cortex_init;
end
