function err = job_view_cortex_selection( action, target1, target2 )
% err = job_view_cortex_selection( action, target1, target2 )
%
%  ΰ?%
% action : 'undo', 'clear', 'register', 'add', or 'delete'
% target1 : action'add''delete'ΤȤΤ߻ : ɲ/??ΰλ?
%           'act', 'area', 'mouse', 'dilation', or 'erosion'
% target2 : target1'act''area'ΤȤΤ߻
%           'union' or 'intersect'
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

H = get( gcf, 'UserData' );
braindata = get( H.braindata, 'UserData' );
actdata = get( H.actdata, 'UserData' );
areadata = get( H.areadata, 'UserData' );
selectdata = get( H.selectdata, 'UserData' );
param = get( H.paramdata, 'UserData' );


switch action
    
 case 'undo'  %-----------------------------------------------------

  if isempty( selectdata.history ); err = 1; return; end
  switch selectdata.history(1).flag
   case 'add'
    selectdata.Vi = setdiff( selectdata.Vi, selectdata.history(1).Vi );
   case 'delete'
    selectdata.Vi = union( selectdata.Vi, selectdata.history(1).Vi );
  end
  selectdata.history = selectdata.history( 2:length(selectdata.history) );
  set( H.selectdata, 'UserData', selectdata );


 case 'clear'  %----------------------------------------------------
    
  if isempty( selectdata.Vi ); err = 1; return; end
  newhistory.flag = 'delete';
  newhistory.Vi = selectdata.Vi;
  selectdata.Vi = [];
  if length( selectdata.history ) < param.selection_undo_length
    selectdata.history = [ newhistory, selectdata.history ];
  else
    selectdata.history = [ newhistory,...
		    selectdata.history(1:length(selectdata.history)-1) ];
  end
  set( H.selectdata, 'UserData', selectdata );
    

 case 'register'  %-------------------------------------------------

  if isempty(areadata.masking)
    mask = [1:length(braindata.V)];  % ޥ̵?
  else
    mask = unique( [ areadata.source(areadata.masking).Vi ] );
  end
  ind = intersect( selectdata.Vi, mask );
  if ~isempty( ind )
    areaname = inputdlg( 'Enter Area Name', 'Area Register', 1 );
    if isempty(areaname) | isempty(areaname{1})
      err = 1; return;
    end
    sourceindmax = length(areadata.source) + 1;
    areadata.source(sourceindmax).Vi = ind;
    areadata.source(sourceindmax).key = areaname{1};
    areadata.candidate = [ areadata.candidate, sourceindmax ];
  end
  set( H.areadata, 'UserData', areadata );


 otherwise  % 'add' or 'delete' ------------------------------------

  % ޤɲ/?????
  Vi_select = [];
  
  switch target1

   case 'act' %%%%%
    switch param.act_relative_mode
     case 'each'
      Jabsmax = max( abs( [ actdata.source(actdata.plotted).J ] ) );
     case 'all'
      Jabsmax = max( abs( [ actdata.source(actdata.candidate).J ] ) );
    end
    for id = actdata.plotted
      J = actdata.source(id).J;
      switch param.act_normalize
       case 'meshsize'
	J = J ./ braindata.Va;
      end
      switch param.act_min_mode
       case 'absolute'
	ind = find( abs(J) >= param.act_min );
       case 'relative'
	ind = find( abs(J) >= Jabsmax * param.act_min );
      end
      switch target2
       case 'union'
	Vi_select = union( Vi_select, ind );
       case 'intersect'
	if id == actdata.plotted(1)
	  Vi_select = ind;
	else
	  Vi_select = intersect( Vi_select, ind );
	end
      end
    end


   case 'area' %%%%%
    
    switch target2
     case 'union'
      Vi_select = unique( [ areadata.source(areadata.plotted).Vi ] );
     case 'intersect'
      Vi_select =areadata.source(areadata.plotted(1)).Vi;
      for i = areadata.plotted(2:length(areadata.plotted))
	Vi_select = intersect( Vi_select, areadata.source(i).Vi );
      end
    end

   case 'mouse' %%%%%
    radius = param.selection_radius;
    [ Ps Vs ] = select3d;
    switch param.model_type
     case 'original'
      V = braindata.V;
     case 'inflate'
      V = braindata.Vinflate;
    end
    distance = sum( ( V - ones( length(V), 1 ) * Vs' ) .^ 2, 2 );
    Vi = find( distance == 0 );
    nextind = find( braindata.nextVd{Vi} <= radius * 10^(-3) );
    Vi_select = braindata.nextVi{Vi}(nextind);

   case 'dilation' %%%%%
    radius = param.dilation_erosion_radius;
    Vflag = zeros(1,length(braindata.V));
    Vflag(selectdata.Vi) = 1;
    for i = selectdata.Vi
      nextind = find( braindata.nextVd{i} <= radius * 10^(-3) );
      Vflag(braindata.nextVi{i}(nextind)) = 1;
    end
    Vi_select = find( Vflag == 1 );
  
   case 'erosion' %%%%%
    radius = param.dilation_erosion_radius;
    Vflag = ones(1,length(braindata.V));
    Vflag(selectdata.Vi) = 0;
    for i = find( Vflag )
      nextind = find( braindata.nextVd{i} <= radius * 10^(-3) );
      Vflag(braindata.nextVi{i}(nextind)) = 1;
    end
    Vi_select = intersect( find( Vflag == 1 ), selectdata.Vi );

  end % switch target1


  % ĺ (Vi_select) ɲ/???
  switch action
   case 'add'  %----------------------------------------------------
    Vi_select = setdiff( Vi_select, selectdata.Vi );
    if isempty( Vi_select ); err = 1; return; end;
    selectdata.Vi = union( selectdata.Vi, Vi_select );
    newhistory.flag = 'add';
   case 'delete' %--------------------------------------------------
    Vi_select = intersect( Vi_select, selectdata.Vi );
    if isempty( Vi_select ); err = 1; return; end;
    selectdata.Vi = setdiff( selectdata.Vi, Vi_select );
    newhistory.flag = 'delete';
  end

  newhistory.Vi = Vi_select;
  if length( selectdata.history ) < param.selection_undo_length
    selectdata.history = [ newhistory, selectdata.history ];
  else
    selectdata.history = [ newhistory,...
		    selectdata.history(1:length(selectdata.history)-1) ];
  end
  set( H.selectdata, 'UserData', selectdata );


end


err = 0;
