function err = job_view_cortex_file( action, target, filepath )
% err = job_view_cortex_file( action, target, filepath )
%
%  et@Cǂݍ݁Af[^i[
%  ܂̓f[^t@Cɏo
%
% action : 'load' or 'save'
% target : 'brain', 'act', or 'area
% filepath : t@C̃pX (ł悢)
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Kvȃf[^̎擾
H = get( gcf, 'UserData' );
data = get( getfield( H, [ target 'data' ] ), 'UserData' );


switch action

 %==================================================================
 %===  t@C̃[h  ===========================================
 %==================================================================
 case 'load'
    
  % t@Cw肳ĂȂ΁AGUIJĎ擾
  if isempty( filepath )
    H.file_dialog.save_mode = 0;
    H.file_dialog.file_extensions = { [ '.' target '.mat' ] };
    [ pname, fname ] = visible( H.file_dialog );
    if length(pname) == 0; err = 1; return; end;
    filepath = fullfile( pname, fname{1} );
  elseif exist( filepath ) ~= 2
    errordlg( [ '''' filepath ''' doesn''t exist' ] );
    err = 1; return;
  end
  
  % Ƀ[hς݂̃t@CȂ...
  if strcmp( data.filename, filepath )
    switch target
     % brain, act ̏ꍇ̓[hȂ
     case { 'brain', 'act' }
      err = 1; return;
     % area ̏ꍇ͍ă[h邩ǂ𕷂
     case 'area'
      reloadp = questdlg( [ 'Are you sure to reload area file '''...
		            filepath ''' ?' ] );
      if ~strcmp( reloadp, 'Yes' ) 
	err = 1; return;
      end
    end
  end

  % t@C̃`FbN --- t@CɕKvȕϐ݂邩H
%  varnames.brain = { 'F', 'V', 'Vinflate', 'inf_C',...
%		     'nextIX', 'nextDD', 'xxA' };
  varnames.brain = { 'F', 'V', ...
		     'nextIX', 'nextDD', 'xxA' };
  varnames.act = { 'Act' };
  varnames.area = { 'MRI_ID', 'Area' };
  vnames = getfield( varnames, target );
  vnames_exist = whos( '-file', filepath, vnames{:} );
  if length( vnames ) ~= length( vnames_exist )
    errordlg( [ '''' filepath ''' is invalid ' target ' file' ] );
    err = 1; return;
  end
  Area = []; % ֐ƃobeBÔŏĂ
  % ϐ̃[h
  load( filepath, vnames{:} );

  % ϐ̃`FbN ????? --- `̕ϐǂ...ʓ|B

  % o^ ( t@C̃f[^\gĥŁAϊ )
  switch target
   case 'brain'
    data.F = F;
    data.V = V;
    for i = 1 : length(V)
      data.nextVi{i} = nextIX{i}';
      data.nextVd{i} = nextDD{i}';
    end
    data.Va = xxA';
    vinf_exist = whos( '-file', filepath, 'Vinflate', 'inf_C');
    if length(vinf_exist) >= 1
      load( filepath, 'Vinflate', 'inf_C');
      if exist('Vinflate')
        data.Vinflate = Vinflate;
        if exist('inf_C')
            data.S = inf_C';
        end
      end
    else
      % Ct[g񂪂ȂꍇA\ݒoriginalɂ
      param = get( H.paramdata, 'UserData' );
      param.model_type = 'original';
      set( H.paramdata, 'UserData', param );
    end
    set(H.fig, 'Name', filepath);

   case 'act'
    data.source = [];
    for i = 1:length(Act)
      data.source(i).key = Act{i}.key;
      data.source(i).J = Act{i}.xxP';
      if isfield( Act{i}, 'comment' )
	data.source(i).comment = Act{i}.comment;
      end
    end
    data.candidate = 1 : length( data.source );
    data.plotted = [];
   case 'area'
    data.MRI_ID = MRI_ID;
    data.source = [];
    for i = 1:length(Area)
      data.source(i).key = Area{i}.key;
      data.source(i).Vi = Area{i}.Iextract';
      if isfield(Area{i}, 'clr')
          data.source(i).color = Area{i}.clr;
      end
    end
    data.candidate = 1 : length( data.source );
    data.plotted = [];
    data.masking = [];
  end
  data.filename = filepath;
  H.file_dialog.current_dir = fileparts( filepath );


 %==================================================================
 %===  t@C̃Z[u  ===========================================
 %==================================================================
 case 'save'
  
  % t@Cw肳ĂȂ΁AGUIJĎ擾
  if isempty( filepath )
    H.file_dialog.save_mode = 1;
    H.file_dialog.file_extensions = { [ '.' target '.mat' ] };
    [ pname, fname ] = visible( H.file_dialog );
    if length(pname) == 0; err = 1; return; end;
    filepath = fullfile( pname, fname{1} );
  end
  
  % tH[}bg𒲐ďo
  switch target
   case 'area'
    count = 0;
    for i = data.candidate
      count = count + 1;
      Area{count}.key = data.source(i).key;
      Area{count}.Iextract = data.source(i).Vi';
    end
    Area = Area';
    MRI_ID = data.MRI_ID;
    vb_fsave( filepath, 'Area', 'MRI_ID' );
    data.filename = filepath;
    H.file_dialog.current_dir = fileparts( filepath );
  end

end


% f[^̊i[
set( getfield( H, [ target, 'data' ] ), 'UserData', data );
set( gcf, 'UserData', H );

err = 0;
