function job_view_cortex_figure( key )
% job_view_cortex_figure
%
%  figureresize
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

switch key
  % figure 
 case 'create'
  H = job_view_cortex_create_figure;
  job_view_cortex_resize_figure( H );
  H.file_dialog = file_dialog;
  set( H.fig, 'ResizeFcn', 'job_view_cortex_figure( ''resize'' )' );
  set( H.fig, 'UserData', H );
  % figure Υ/Position
 case 'resize'
  H = get( gcf, 'UserData' );
  job_view_cortex_resize_figure( H );;
end

  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function H = job_view_cortex_create_figure()

graycolor = [ 0.8,0.8,0.8 ];
whitecolor = [ 1,1,1 ];


%---------------------------------------------------------------------
% Figure 

H.fig = figure( 'Tag', 'job_view_cortex main',...
		'Menubar', 'none',...
        'NumberTitle', 'off',...
		'Color', graycolor,...
		'Units', 'pixels',...
		'WindowButtonMotionFcn',...
		    'job_view_cortex_callback(''mouse move'');',...
		'CloseRequestFcn', 'job_view_cortex_callback(''close'');',...
		'DefaultUicontrolHitTest', 'off',...
		'DefaultUicontrolBackgroundColor', graycolor,...
		'DefaultUicontrolFontUnits', 'pixels',...
		'DefaultUicontrolFontSize', 12, ...
		'DefaultUicontrolHorizontalAlignment', 'left' );

%---------------------------------------------------------------------
% Brain

H.brain_frame = uicontrol(...
    'Style', 'frame' );

H.brain_frame_label = uicontrol(...
    'Style', 'text',...
    'String', 'Brain Model' );

H.brain_file_label = uicontrol(...
    'Style', 'text',...
    'String', 'Brain File' );

H.brain_file_name = uicontrol(...
    'Style', 'edit',...
    'String', '',...
    'Enable', 'inactive',...
    'BackgroundColor', whitecolor );

H.brain_file_load_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''brain load file button'');',...
    'Selected', 'on',...
    'String', 'load',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );



%---------------------------------------------------------------------
% Activation ɽ

H.activation_frame = uicontrol(...
    'Style', 'frame' );

H.activation_frame_label = uicontrol(...
    'Style', 'text',...
    'String', 'Activation' );

H.activation_file_label = uicontrol(...
    'Style', 'text',...
    'String', 'File' );

H.activation_file_name = uicontrol(...
    'Style', 'edit',...
    'String', '',...
    'Enable', 'inactive',...
    'BackgroundColor', whitecolor );

H.activation_file_load_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''act load file button'');',...
    'Enable', 'off', ...
    'String', 'load',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.activation_list = uicontrol(...
    'Style', 'listbox',...
    'Callback', 'job_view_cortex_callback(''act list select'');',...
    'String', {},...
    'Value', [],...
    'Max', 2, 'Min', 0,...
    'HitTest', 'on',...
    'BackgroundColor', whitecolor );

H.activation_list_label = uicontrol(...
    'Style', 'text',...
    'String', 'Activation List' );

H.activation_plotted_add_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',....
        'job_view_cortex_callback(''act add to plotted list button'');',...
    'String', 'add',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.activation_plotted_delete_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
      'job_view_cortex_callback(''act delete from plotted list button'');',...
    'String', 'del.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.activation_plotted_clear_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
        'job_view_cortex_callback(''act clear plotted list button'');',...
    'String', 'clear',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.activation_plotted_list = uicontrol(...
    'Style', 'listbox',...
    'Callback',....
        'job_view_cortex_callback(''act plotted list select'');',...
    'String', {},...
    'Value', [],...
    'Max', 2, 'Min', 0,...
    'HitTest', 'on',...
    'BackgroundColor', whitecolor );

H.activation_plotted_list_label = uicontrol(...
    'Style', 'text',...
    'String', 'Plotted Activation' );



%---------------------------------------------------------------------
% ΰɽ/ޥ

H.area_frame = uicontrol(...
    'Style', 'frame' );
    
H.area_frame_label = uicontrol(...
    'Style', 'text',...
    'String', 'Area Plot / Mask' );

H.area_file_label = uicontrol(...
    'Style', 'text',...
    'String', 'File' );

H.area_file_name = uicontrol(...
    'Style', 'edit',...
    'String', '',...
    'Enable', 'inactive',...
    'BackgroundColor', whitecolor );

H.area_file_load_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''area load file button'');',...
    'Enable', 'off',...
    'String', 'load',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_file_save_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''area save file button'');',...
    'Enable', 'off',...
    'String', 'save',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_list = uicontrol(...
    'Style', 'listbox',...
    'Callback', 'job_view_cortex_callback(''area list select'');',...
    'String', {},...
    'Value', [],...
    'Max', 2, 'Min', 0,...
    'HitTest', 'on',...
    'BackgroundColor', whitecolor );

H.area_list_label = uicontrol(...
    'Style', 'text',...
    'String', 'Area List' );

H.area_plotted_add_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
        'job_view_cortex_callback(''area add to plotted list button'');',...
    'String', 'add',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_plotted_delete_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
      'job_view_cortex_callback(''area delete from plotted list button'');',...
    'String', 'del.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_plotted_clear_button = uicontrol(...
    'Style', 'pushbutton',...	
    'CallBack',...
        'job_view_cortex_callback(''area clear plotted list button'');',...
    'String', 'clear',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_plotted_list = uicontrol(...
    'Style', 'listbox',...
    'Callback', 'job_view_cortex_callback(''area plotted list select'');',...
    'String', {},...
    'Value', [],...
    'Max', 2, 'Min', 0,...
    'HitTest', 'on',...
    'BackgroundColor', whitecolor );

H.area_plotted_list_label = uicontrol(...
    'Style', 'text',...
    'String', 'Plotted Area' );

H.area_masking_add_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
        'job_view_cortex_callback(''area add to masking list button'');',...
    'String', 'add',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_masking_delete_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
      'job_view_cortex_callback(''area delete from masking list button'');',...
    'String', 'del.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_masking_clear_button = uicontrol(...
    'Style', 'pushbutton',...
    'CallBack',...
        'job_view_cortex_callback(''area clear masking list button'');',...
    'String', 'clear',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.area_masking_list = uicontrol(...
    'Style', 'listbox',...
    'Callback', 'job_view_cortex_callback(''area masking list select'');',...
    'String', {},...
    'Value', [],...
    'Max', 2, 'Min', 0,...
    'HitTest', 'on',...
    'BackgroundColor', whitecolor );

H.area_masking_list_label = uicontrol(...
    'Style', 'text',...
    'String', 'Masking Area' );

H.area_list_delete_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''area list delete button'')',...
    'String', 'del.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );



%---------------------------------------------------------------------
% ޥǽ ( ।/, ž, ĺ )

H.mouse_func_frame = uicontrol(...
    'Style', 'frame' );

H.mouse_func_frame_label = uicontrol(...
    'Style', 'text',...
    'String', 'Mouse Function' );

H.mouse_func_radioZ = uicontrol(...
    'Style', 'radiobutton',...
    'Callback', 'job_view_cortex_callback(''mouse func Z'');',...
    'String', 'Zoom In/Out',...
    'Max', 1,...
    'Min', 0,...
    'HitTest', 'on',...
    'Value', 0 );

H.mouse_func_radioR = uicontrol(...
    'Style', 'radiobutton',...
    'Callback', 'job_view_cortex_callback(''mouse func R'');',...
    'String', 'Rotation',...
    'Max', 1,...
    'Min', 0,...
    'HitTest', 'on',...
    'Value', 1 );

H.mouse_func_radioS = uicontrol(...
    'Style', 'radiobutton',...
    'Callback', 'job_view_cortex_callback(''mouse func S'');',...
    'String', 'Add Selection',...
    'Max', 1,...
    'Min', 0,...
    'HitTest', 'on',...
    'Value', 0 );

H.mouse_func_radioU = uicontrol(...
    'Style', 'radiobutton',...
    'Callback', 'job_view_cortex_callback(''mouse func U'');',...
    'String', 'Delete Selection',...
    'Max', 1,...
    'Min', 0,...
    'HitTest', 'on',...
    'Value', 0 );



%---------------------------------------------------------------------
% ΰ

H.selection_frame = uicontrol(...
    'Style', 'frame' );

H.selection_frame_label = uicontrol(...
    'Style', 'text',...
    'String', 'Selection' );

H.selection_num_vertex = uicontrol(...
    'Style', 'edit',...
    'String', '0',...
    'BackgroundColor', whitecolor,...
    'Enable', 'inactive',...
    'HorizontalAlignment', 'right' );

H.selection_num_vertex_label = uicontrol(...
    'Style', 'text',...
    'String', 'verticies selected' );

H.selection_undo_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''selection undo button'');',...
    'String', 'undo',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_clear_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''selection clear button'');',...
    'String', 'clear',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_dilation_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''selection dilation button'');',...
    'String', 'dilation',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_erosion_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''selection erosion button'');',...
    'String', 'erosion',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_register_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback', 'job_view_cortex_callback(''selection register button'');',...
    'String', 'register',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_act_label = uicontrol(...
    'Style', 'text',...
    'String', 'Activation' );

H.selection_add_intersect_act_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
        'job_view_cortex_callback(''selection add intersect act button'');',...
    'String', 'add int.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_delete_intersect_act_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
     'job_view_cortex_callback(''selection delete intersect act button'');',...
    'String', 'del. int.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_add_union_act_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
        'job_view_cortex_callback(''selection add union act button'');',...
    'String', 'add union',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_delete_union_act_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
        'job_view_cortex_callback(''selection delete union act button'');',...
    'String', 'del. union',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_area_label = uicontrol(...
    'Style', 'text',...
    'String', 'Area' );

H.selection_add_intersect_area_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
      'job_view_cortex_callback(''selection add intersect area button'');',...
    'String', 'add int.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_delete_intersect_area_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
    'job_view_cortex_callback(''selection delete intersect area button'');',...
    'String', 'del. int.',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_add_union_area_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
        'job_view_cortex_callback(''selection add union area button'');',...
    'String', 'add union',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.selection_delete_union_area_button = uicontrol(...
    'Style', 'pushbutton',...
    'Callback',...
        'job_view_cortex_callback(''selection delete union area button'');',...
    'String', 'del. union',...
    'Enable', 'off',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );



%---------------------------------------------------------------------
% Plot 

H.set_param_button = uicontrol(...
    'Style', 'pushbutton',...
    'String', 'set parameters',...
    'Callback', 'job_view_cortex_callback(''set param'');',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.print_button = uicontrol(...
    'Style', 'pushbutton',...
    'String', 'print',...
    'Callback', 'job_view_cortex_callback(''print'');',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.close_button = uicontrol(...
    'Style', 'pushbutton',...
    'String', 'close',...
    'Callback', 'job_view_cortex_callback(''close'');',...
    'HitTest', 'on',...
    'HorizontalAlignment', 'center' );

H.plot_axes = axes(...
    'Visible', 'on',...
    'Color', whitecolor,...
    'XTick', [], 'YTick', [], 'ZTick', [],...
    'Box', 'on',...
    'DataAspectRatio', [1,1,1],...
    'PlotBoxAspectRatioMode', 'manual',...
    'SelectionHighlight', 'off',...
    'HitTest', 'on',...
    'Clipping', 'off',...
    'Units', 'pixels' );
hold on;

%---------------------------------------------------------------------
% data Ǽ

H.data = uicontrol( 'Style', 'frame', 'Visible', 'off', 'Enable', 'off' );
H.braindata = uicontrol( 'Style', 'frame', 'Visible', 'off', 'Enable', 'off' );
H.actdata = uicontrol( 'Style', 'frame', 'Visible', 'off', 'Enable', 'off' );
H.areadata = uicontrol( 'Style', 'frame', 'Visible', 'off', 'Enable', 'off' );
H.selectdata = uicontrol( 'Style', 'frame', 'Visible', 'off', 'Enable', 'off' );
H.paramdata = uicontrol( 'Style', 'frame', 'Visible', 'off', 'Enable', 'off' );





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function job_view_cortex_resize_figure( H )


% figure 

minwidth = 1200;
minheight = 900;

screensize = get( 0, 'ScreenSize' );
figpos = get( H.fig, 'Position' );

if figpos(3) < minwidth
  figpos(3) = minwidth;
end

if figpos(4) < minheight
  figpos(2) = figpos(2)-(minheight-figpos(4));
  figpos(4) = minheight;
end

set( H.fig, 'Position', figpos );


% ƥե졼position

fig_w = figpos(3);
fig_h = figpos(4);

list_w = fig_w/6;
list_h = (fig_h-220)/3;

leftpart_l = 10;
leftpart_w = list_w * 2 + 55;
rightpart_l = leftpart_l + leftpart_w + 10;
rightpart_w = 315;

brain_l = leftpart_l;
brain_t = fig_h - 15;
brain_w = leftpart_w;
brain_h = 35;
brain_b = brain_t - brain_h;

act_l = leftpart_l;
act_t = brain_b - 15;
act_w = leftpart_w;
act_h = list_h + 55;
act_b = act_t - act_h;

area_l = leftpart_l;
area_t = act_b - 15;
area_w = leftpart_w;
area_h = list_h * 2 + 75;
area_b = area_t - area_h;

select_l = rightpart_l;
select_b = 10;
select_w = rightpart_w;
select_h = 75;
select_t = select_b + select_h;

mouse_l = rightpart_l;
mouse_b = select_t + 15;
mouse_w = rightpart_w;
mouse_h = 55;
mouse_t = mouse_b + mouse_h;

axis_l = rightpart_l;
axis_t = fig_h - 35;
axis_w = fig_w - axis_l - 10;
axis_h = fig_h - mouse_b - mouse_h - 45;
axis_b = axis_t - axis_h;


% brain part  position

set( H.brain_frame,...
     'Position', [brain_l,brain_b,brain_w,brain_h] );
set( H.brain_frame_label,...
     'Position', [brain_l+10,brain_t-10,75,16] );
set( H.brain_file_label,...
     'Position', [brain_l+5,brain_t-30,70,16] );
set( H.brain_file_name,...
     'Position', [brain_l+75,brain_t-30,brain_w-120,20] );
set( H.brain_file_load_button,...
     'Position', [brain_l+brain_w-45,brain_t-30,35,20] );


% activation part  position

set( H.activation_frame,...
     'Position', [act_l,act_b,act_w,act_h] );
set( H.activation_frame_label,...
     'Position', [act_l+10,act_t-10,65,16] );
set( H.activation_file_label,...
     'Position', [act_l+5,act_t-30,30,16] );
set( H.activation_file_name,...
     'Position', [act_l+35,act_t-30,act_w-120,20] );
set( H.activation_file_load_button,...
     'Position', [act_l+act_w-85,act_t-30,35,20] );
set( H.activation_list,...
     'Position', [act_l+5,act_b+5,list_w,act_h-55] );
set( H.activation_list_label,...
     'Position', [act_l+5,act_t-50,list_w,16] );
set( H.activation_plotted_list,...
     'Position', [act_l+list_w+50,act_b+5,list_w,list_h] );
set( H.activation_plotted_list_label,...
     'Position', [act_l+list_w+50,act_t-50,list_w,16] );
set( H.activation_plotted_add_button,...
     'Position', [act_l+list_w+8,act_t-70,40,20] );
set( H.activation_plotted_delete_button,...
     'Position', [act_l+list_w+8,act_t-90,40,20] );
set( H.activation_plotted_clear_button,...
     'Position', [act_l+list_w+8,act_t-110,40,20] );


% area part  position

set( H.area_frame,...
     'Position', [area_l,area_b,area_w,area_h] );
set( H.area_frame_label,...
     'Position', [area_l+10,area_t-10,100,16] );
set( H.area_file_label,...
     'Position', [area_l+5,area_t-30,30,16] );
set( H.area_file_name,...
     'Position', [area_l+35,area_t-30,area_w-120,20] );
set( H.area_file_load_button,...
     'Position', [area_l+area_w-85,area_t-30,35,20] );
set( H.area_file_save_button,...
     'Position', [area_l+area_w-50,area_t-30,35,20] );
set( H.area_list,...
     'Position', [area_l+5,area_b+25,list_w,area_h-75] );
set( H.area_list_label,...
     'Position', [area_l+5,area_t-50,list_w,16] );
set( H.area_list_delete_button,...
     'Position', [area_l+5,area_b+5,40,20] );
set( H.area_plotted_list,...
     'Position', [area_l+list_w+50,area_t-50-list_h,list_w,list_h] );
set( H.area_plotted_list_label,...
     'Position', [area_l+list_w+50,area_t-50,list_w,16] );
set( H.area_plotted_add_button,...
     'Position', [area_l+list_w+8,area_t-70,40,20] );
set( H.area_plotted_delete_button,...
     'Position', [area_l+list_w+8,area_t-90,40,20] );
set( H.area_plotted_clear_button,...
     'Position', [area_l+list_w+8,area_t-110,40,20] );
set( H.area_masking_list,...
     'Position', [area_l+list_w+50,area_b+5,list_w,list_h] );
set( H.area_masking_list_label,...
     'Position', [area_l+list_w+50,area_b+list_h+5,list_w,16] );
set( H.area_masking_add_button,...
     'Position', [area_l+list_w+8,area_b+list_h-15,40,20] );
set( H.area_masking_delete_button,...
     'Position', [area_l+list_w+8,area_b+list_h-35,40,20] );
set( H.area_masking_clear_button,...
     'Position', [area_l+list_w+8,area_b+list_h-55,40,20] );


% mouse func part  position

set( H.mouse_func_frame,...
     'Position', [mouse_l,mouse_b,mouse_w,mouse_h] );
set( H.mouse_func_frame_label,...
     'Position', [mouse_l+10,mouse_t-10,100,16] );
set( H.mouse_func_radioZ,...
     'Position', [mouse_l+5,mouse_t-30,100,20] );
set( H.mouse_func_radioR,...
     'Position', [mouse_l+5,mouse_t-50,100,20] );
set( H.mouse_func_radioS,...
     'Position', [mouse_l+110,mouse_t-30,120,20] );
set( H.mouse_func_radioU,...
     'Position', [mouse_l+110,mouse_t-50,120,20] );


% selection part  position

set( H.selection_frame,...
     'Position', [select_l,select_b,select_w,select_h] );
set( H.selection_frame_label,...
     'Position', [select_l+10,select_t-10,60,16] );
set( H.selection_num_vertex,...
     'Position', [select_l+100,select_t-10,35,20] );
set( H.selection_num_vertex_label,...
     'Position', [select_l+135,select_t-10,105,16] );
set( H.selection_undo_button,...
     'Position', [select_l+5,select_t-30,40,20] );
set( H.selection_clear_button,...
     'Position', [select_l+45,select_t-30,40,20] );
set( H.selection_dilation_button,...
     'Position', [select_l+85,select_t-30,50,20] );
set( H.selection_erosion_button,...
     'Position', [select_l+135,select_t-30,50,20] );
set( H.selection_register_button,...
     'Position', [select_l+190,select_t-30,55,20] );
set( H.selection_act_label,...
     'Position', [select_l+5,select_t-50,65,16 ] );
set( H.selection_add_intersect_act_button,...
     'Position', [select_l+70,select_t-50,50,20] );
set( H.selection_delete_intersect_act_button,...
     'Position', [select_l+120,select_t-50,50,20] );
set( H.selection_add_union_act_button,...
     'Position', [select_l+170,select_t-50,70,20] );
set( H.selection_delete_union_act_button,...
     'Position', [select_l+240,select_t-50,70,20] );
set( H.selection_area_label,...
     'Position', [select_l+5,select_t-70,65,16 ] );
set( H.selection_add_intersect_area_button,...
     'Position', [select_l+70,select_t-70,50,20] );
set( H.selection_delete_intersect_area_button,...
     'Position', [select_l+120,select_t-70,50,20] );
set( H.selection_add_union_area_button,...
     'Position', [select_l+170,select_t-70,70,20] );
set( H.selection_delete_union_area_button,...
     'Position', [select_l+240,select_t-70,70,20] );


% ¾ position

set( H.set_param_button,...
     'Position', [rightpart_l,axis_t+5,95,20] );
set( H.print_button,...
     'Position', [rightpart_l+95,axis_t+5,40,20] );
set( H.close_button,...
     'Position', [fig_w-50,axis_t+5,40,20] );
set( H.plot_axes,...
     'Position', [axis_l,axis_b,axis_w,axis_h] );
