function job_plot_meg_update_timecourse(inst_id,flag)
% Update timecourse of MEG signal
%
% --- Syntax
% function job_plot_meg_update_timecourse(inst_id,flag)
%
% --- History
% 2008-09-02 Taku Yoshioka
% 2015-12-14 rhayashi
%      save showing data(selected_sensor_name, plotting_timecourse)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
define_job_plot_meg_const;
if isempty(vbmeg_inst.plotmeg{inst_id}.bexp), return; end
if ~exist('flag', 'var'), flag = []; end;

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.plotmeg{inst_id}.h_fig; 
h_time = vbmeg_inst.plotmeg{inst_id}.h_time;
n_trial = vbmeg_inst.plotmeg{inst_id}.n_trial;
T = vbmeg_inst.plotmeg{inst_id}.T;
N = vbmeg_inst.plotmeg{inst_id}.N;
t = vbmeg_inst.plotmeg{inst_id}.t;
rb1 = vbmeg_inst.plotmeg{inst_id}.rb1;
twin_lim = vbmeg_inst.plotmeg{inst_id}.twin_lim;
bexp = vbmeg_inst.plotmeg{inst_id}.bexp(:,:,n_trial);
MEGinfo = vbmeg_inst.plotmeg{inst_id}.MEGinfo;
ylabel_str = vbmeg_inst.plotmeg{inst_id}.ylabel_str;

%
% Time window range check
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if t(1)<min(T(twin_lim)), t(1)=min(T(twin_lim)); end;
if t(1)>max(T(twin_lim)), t(1)=max(T(twin_lim)); end;
if t(2)<min(T(twin_lim)), t(2)=min(T(twin_lim)); end;
if t(2)>max(T(twin_lim)), t(2)=max(T(twin_lim)); end;
if t(1)>t(2), t=t(2:-1:1); end;
vbmeg_inst.plotmeg{inst_id}.t = t; 

%
% Select sensor
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sensor_type = vbmeg_inst.plotmeg{inst_id}.sensor_type;
ch_name = [];
if isfield(vbmeg_inst.plotmeg{inst_id}.MEGinfo.ChannelInfo, 'Name')
    ch_name = vbmeg_inst.plotmeg{inst_id}.MEGinfo.ChannelInfo.Name;
end

if sensor_type~=-1, 
  ix = find(MEGinfo.ChannelInfo.Type==sensor_type);
  bexp = bexp(ix,:);
  ch_name = ch_name(ix);
end

if isfield(vbmeg_inst.plotmeg{inst_id}, 'selected_sensor')
    selected_sensor_ix = vbmeg_inst.plotmeg{inst_id}.selected_sensor;
    if ~isempty(selected_sensor_ix)
        bexp = bexp(selected_sensor_ix, :);
        if ~isempty(ch_name)
            vbmeg_inst.plotmeg{inst_id}.selected_sensor_name = ch_name(selected_sensor_ix);
        end
    else
        vbmeg_inst.plotmeg{inst_id}.selected_sensor_name = ch_name;
    end
end
vbmeg_inst.plotmeg{inst_id}.plotting_timecourse = bexp;

%
% Plot time course
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'CurrentAxes',h_time);
if flag == FORCE_UPDATE
  cla(h_time);
  if get(rb1,'Value')==1, 
    h_plot = plot(T,sqrt(sum(bexp.^2,1)/size(bexp,1)));
  else
    h_plot = plot(repmat(T,[size(bexp,1) 1])',bexp');
  end
  set(h_plot, 'HitTest', 'off');
  set(h_time, 'Box', 'off');
  set(h_time, 'TickDir', 'out');
  xlim([min(T) max(T)]);
  xlabel('Time [ms]');
  ylabel(ylabel_str);
  %ylabel('MEG signal [fT]');
end

%
% Set callback function
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
str = ['vbmeg_inst.plotmeg{' num2str(inst_id) '}']; 
command = ['global vbmeg_inst; ' ...
	   str '.t = xrange;' ...
	   'inst_id = job_plot_meg_get_inst_id(gcf);' ...
	   'job_plot_meg_update_timecourse(inst_id);' ...
	   'job_plot_meg_update_spatialpattern(inst_id);'];
select_xrange('init',gca,'ButtonUpFcn',command,...
	      'InitialRange',t);

%
% Convert Timewindow from msec to index
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
temp = abs(T - t(1));
twin_meg(1) = min(find(temp == min(temp)));
temp = abs(T - t(2));
twin_meg(2) = min(find(temp == min(temp)));
vbmeg_inst.plotmeg{inst_id}.twin_meg = twin_meg;

%
% Update text box
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(vbmeg_inst.plotmeg{inst_id}.ed2,'String',num2str(t(1))); 
set(vbmeg_inst.plotmeg{inst_id}.ed3,'String',num2str(t(2))); 
set(vbmeg_inst.plotmeg{inst_id}.twin_min_range, 'String', num2str(T(min(twin_lim))));
set(vbmeg_inst.plotmeg{inst_id}.twin_max_range, 'String', num2str(T(max(twin_lim))));
