function job_plot_meg_search_peak(inst_id)
%
% Search peak
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
define_job_plot_meg_const;

% Global variables
n_trial = vbmeg_inst.plotmeg{inst_id}.n_trial;
T = vbmeg_inst.plotmeg{inst_id}.T;
ed4 = vbmeg_inst.plotmeg{inst_id}.ed4;
twin_meg = vbmeg_inst.plotmeg{inst_id}.twin_meg;

% Time window size
Tsize = str2num(get(ed4,'String'));
if Tsize<0, 
  Tsize=10; 
  set(ed4,'Value','10');
end

% Search peak
ix = twin_meg(1):twin_meg(2);
tmp = sum((vbmeg_inst.plotmeg{inst_id}.bexp(:,ix,n_trial)).^2,1);
[tmp,ix] = max(tmp);
ix = ix+twin_meg(1)-1;

% Update time window
vbmeg_inst.plotmeg{inst_id}.t(1) = T(ix)-Tsize;
vbmeg_inst.plotmeg{inst_id}.t(2) = T(ix)+Tsize;

% Update spatiotemporal pattern
job_plot_meg_update_timecourse(inst_id,FORCE_UPDATE);
job_plot_meg_update_spatialpattern(inst_id);
