function job_plot_meg_choose_plot_sensor(inst_id, mouse_mode)
% Choose plot sensor on contourmap.
%
% [Usage]
%    job_plot_meg_choose_plot_sensor(inst_id, mouse_mode)
%
% [Input]
%       inst_id : instance id
%    mouse_mode : 1: mouse down event.
%   
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('inst_id', 'var')
    error('inst_id is a required parameter.');
end
if ~exist('mouse_mode', 'var')
    error('mouse_mode is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
h_space = vbmeg_inst.plotmeg{inst_id}.h_space; % contour axes handle

switch(mouse_mode)
    case 1
        method = vbmeg_inst.plotmeg{inst_id}.sensor_selection_method;

        %get(gcbf, 'SelectionType');
        % show sensor selection method menu by right clicking.
        if strcmp(get(gcbf, 'SelectionType'), 'alt')
            inner_selection_method_change(inst_id, method);
            return;
        elseif strcmp(get(gcbf, 'SelectionType'), 'open')
            % double click
            return;
        end
        % reset selection state
        job_plot_meg_choose_plot_sensor(inst_id, 'reset');

        % Get sensor coordinate value on contour map
        h_plot = findobj(get(h_space, 'children'), 'Type', 'line');
        % Select sensor
        method = vbmeg_inst.plotmeg{inst_id}.sensor_selection_method;
        [ix, Xdata, Ydata] = vb_data_pick_tool('sel',          method,  ...
                                               'Target',       h_plot,  ...
                                               'Axes',         h_space, ...
                                               'FlagColor',       'k',  ...
                                               'FlagEdgeColor', 'w');
        if ~isempty(ix)
            vbmeg_inst.plotmeg{inst_id}.selected_sensor_XY = [Xdata, Ydata];

            % Plot marker
            job_plot_meg_choose_plot_sensor(inst_id, 'plot');
        end

        %
        % --- Set selected sensor index to data structure.
        %
        vbmeg_inst.plotmeg{inst_id}.selected_sensor     = ix;

        %
        % --- Plot timecourse
        %
        define_job_plot_meg_const;
        job_plot_meg_update_timecourse(inst_id, FORCE_UPDATE);

    case 'plot'
        % Plot marker
        XYdata = vbmeg_inst.plotmeg{inst_id}.selected_sensor_XY;
        if ~isempty(XYdata)
            hold on;
            vbmeg_inst.plotmeg{inst_id}.selected_sensor_plot = ...
                plot(XYdata(:,1), XYdata(:,2), 'wo', 'MarkerFaceColor', 'k');
        end
    case 'reset'
        inner_remove_selected_point(inst_id);
        vbmeg_inst.plotmeg{inst_id}.selected_sensor_name= cell(0);
        vbmeg_inst.plotmeg{inst_id}.selected_sensor     = [];
        vbmeg_inst.plotmeg{inst_id}.selected_sensor_XY  = [];
        vbmeg_inst.plotmeg{inst_id}.selected_sensor_plot= [];
    otherwise
        error('Unknown mouse operation was detected.');
end

function inner_remove_selected_point(inst_id)

global vbmeg_inst;
if ~isfield(vbmeg_inst.plotmeg{inst_id}, 'selected_sensor_plot')
    return;
end
objects = vbmeg_inst.plotmeg{inst_id}.selected_sensor_plot;
if ~isempty(objects)
    for k=1:length(objects)
        if ishandle(objects(k)) && ~isempty(ishandle(objects(k)))
            %disp('All points are deleted.');
            delete(objects(k));
        end
    end
end
vbmeg_inst.plotmeg{inst_id}.selected_sensor_plot = [];

function inner_selection_method_change(inst_id, current_method)

% Create the UICONTEXTMENU
cmenu = uicontextmenu;
sel_menu = uimenu(cmenu,'label','Sensor selection method');

callback = ['global vbmeg_inst; vbmeg_inst.plotmeg{' num2str(inst_id), ...
            '}.sensor_selection_method = '];

h1 = uimenu(sel_menu, 'Label','Brush', 'Callback', [callback, '''Brush'';']);
h2 = uimenu(sel_menu, 'Label','Lasso', 'Callback', [callback, '''Lasso'';']);
h3 = uimenu(sel_menu, 'Label','Rect',  'Callback', [callback, '''Rect'';']);

switch(current_method)
    case 'Brush'
        set(h1, 'Checked', 'on');
    case 'Lasso'
        set(h2, 'Checked', 'on');
    case 'Rect'
        set(h3, 'Checked', 'on');
end
set(gca, 'UIContextMenu', cmenu);


