function [update_flag] = vb_table_query_update_flag(tbl, key)
% get update_flag from table.
% [USAGE]
%    [update_flag] = vb_table_query_update_flag(tbl, key);
% [IN]
%    tbl : table data.
%    key : search key.
% [OUT]
%    update_flag : update_flag in the specified record.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tbl', 'var')
    error('tbl is a required parameter.');
end
if ~exist('key', 'var')
    error('key is a required parameter.');
end
if ~ischar(key)
    error('key should be string.');
end


%
% --- Main Procedure
%
update_flag = [];

if ~isempty(tbl)
    if ~isfield(tbl(1), 'update_flag')
        error('Specified table doesn''t have ''update_flag'' field.');
    end
    ix = strmatch(key, {tbl.key}, 'exact');
    if ~isempty(ix)
        update_flag = tbl(ix).update_flag;
    end
end
