function job_plot_cmap_update_area(inst_id)
% Update cortical area.
% 
% [history]
% 2011-03-14 taku-y
% 2011-04-04 taku-y
%  [enhancement] Multiple cortical area plot supported. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
area_file = vbmeg_inst.plotcmap{inst_id}.area_file;
lb2       = vbmeg_inst.plotcmap{inst_id}.lb2;

%
% Update activity map
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(area_file),
  area_key = get(lb2,'String');
  ix_key  = get(lb2,'Value');
  vbmeg_inst.plotcmap{inst_id}.area_key = cell(0,0);
  for i=1:length(ix_key)
    vbmeg_inst.plotcmap{inst_id}.area_key{i} = area_key{ix_key(i)};
  end
end

return;