function [cond] = job_plot_cmap_setting_dlg_is_requirement_filled(fig)
% return check result that userinput fill the requirement.
% [USAGE]
%    [cond] = job_plot_cmap_setting_dlg_is_requirement_filled(fig);
% [IN]
%    fig : figure handle
% [OUT]
%    cond : user input fill the requirement? <<bool>>
%           = true  : fill the requirement.
%           = false : not fill the requirement.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
cond = false;
if ~ishandle(fig) || isempty(fig)
    error('Specified figure is invalid.');
end

%
% --- Main Procedure
%
private_data = guidata(fig);
if isempty(private_data), return, end

H = guihandles(fig);

% which is required? (current or tf) file
if get(H.data_file_current_radiobutton, 'Value')
    view_mode = 'current';
elseif get(H.data_file_tf_radiobutton, 'Value')
    view_mode = 'tf';
else
    error('Specified view mode is unknown.');
end

% required parameter
mode = private_data.mode;

% already loaded file
file_on_app = private_data.file_on_app;

% requirement check
cond = true;

% case : brain_file is required(always true)
brain_is_required = true;
brain_update = get(H.brain_file_update_checkbox, 'Value');
brain_already_read   = bitget(file_on_app, 1);
brain_file = get(H.brain_file_edit, 'String');
set_error_msg_to_info_msgbox(H.info_edit, 'brain_file', OFF);
if brain_is_required
    if brain_update && is_file_exist(brain_file)
        % ready to read brain_file(No problem)
    elseif brain_already_read && brain_update == false
        % brain_file is already read(No problem)
    else
        % Problem
        cond = false;
        set_error_msg_to_info_msgbox(H.info_edit, 'brain_file', ON, brain_file);
    end
end


curr_tf_mode = bitget(mode, 1);
current_is_required = curr_tf_mode && strcmp(view_mode, 'current');
% case : current_file is required.
current_update = get(H.current_file_update_checkbox, 'Value');
current_already_read = bitget(file_on_app, 4);
current_file = get(H.current_file_edit, 'String');

% case : tf_file is required.
tf_is_required = curr_tf_mode && strcmp(view_mode, 'tf');
tf_update = get(H.tf_file_update_checkbox, 'Value');
tf_already_read = bitget(file_on_app, 5);
tf_file = get(H.tf_file_edit, 'String');

set_error_msg_to_info_msgbox(H.info_edit, 'current_file', OFF);
set_error_msg_to_info_msgbox(H.info_edit, 'tf_file', OFF);
if current_is_required
    if current_update && is_file_exist(current_file)
        % ready to read current_file(No problem)
    elseif current_already_read && current_update == false
        % current_file is already read(No problem)
    else
        % Problem
        cond = false;
        set_error_msg_to_info_msgbox(H.info_edit, 'current_file', ON, current_file);
    end
elseif tf_is_required
    if tf_update && is_file_exist(tf_file)
        % ready to read tf_file(No problem)
    elseif tf_already_read && tf_update == false
        % tf_file is already read(No problem)
    else
        % Problem
        cond = false;
        set_error_msg_to_info_msgbox(H.info_edit, 'tf_file', ON, tf_file);
    end
end

% case : area_file is required.
area_is_required = bitget(mode, 2);
area_update = get(H.area_file_update_checkbox, 'Value');
area_already_read = bitget(file_on_app, 2);
area_file = get(H.area_file_edit, 'String');
set_error_msg_to_info_msgbox(H.info_edit, 'area_file', OFF);
if area_is_required
    if area_update && is_file_exist(area_file)
        % ready to read area_file(No problem)
    elseif area_already_read && area_update == false
        % area_file is already read(No problem)
    else
        % Problem
        cond = false;
        set_error_msg_to_info_msgbox(H.info_edit, 'area_file', ON, area_file);
    end
elseif area_update && ~is_file_exist(area_file)
    % Problem
    cond = false;
    set_error_msg_to_info_msgbox(H.info_edit, 'area_file', ON, area_file);
end

% case : act_file is required.
act_is_required = bitget(mode, 3);
act_update = get(H.act_file_update_checkbox, 'Value');
act_already_read = bitget(file_on_app, 3);
act_file = get(H.act_file_edit, 'String');
set_error_msg_to_info_msgbox(H.info_edit, 'act_file', OFF);
if act_is_required
    if act_update && is_file_exist(act_file)
        % ready to read act_file(No problem)
    elseif act_already_read && act_update == false
        % act_file is already read(No problem)
    else
        % Problem
        cond = false;
        set_error_msg_to_info_msgbox(H.info_edit, 'act_file', ON, act_file);
    end
elseif act_update && ~is_file_exist(act_file)
    % Problem
    cond = false;
    set_error_msg_to_info_msgbox(H.info_edit, 'act_file', ON, act_file);
end

function ret = is_file_exist(file)
ret = false;
if exist(file, 'file') == 2
    ret = true;
end

function set_error_msg_to_info_msgbox(comp_desc, file_type, on_off, file)

if ~exist('on_off', 'var'), on_off = ON; end;

str = get(comp_desc, 'String');
if isempty(str)
    str = cell(0);
else
    str = cellstr(str);
end

switch(file_type)
    case 'brain_file'
        msg = '- Cortical model file';
    case 'area_file'
        msg = '- Cortical area file';
    case 'act_file'
        msg = '- Cortical act file';
    case 'current_file'
        msg = '- Current file';
    case 'tf_file'
        msg = '- Time frequency file';
    otherwise
        error('Unknown file_type was specified.');
end

ix = strmatch(msg, str);
if on_off == ON
    % error ON
    if isempty(file)
        reason = ' is required.';
    elseif exist(file, 'file') == 2
        reason = ' should be applied.';
    else
        reason = ' is invalid.';
    end
    if isempty(ix)
        str{end+1} = [msg, reason];
    end
else
    % error OFF
    if ~isempty(ix)
        % remove msg
        str(ix) = [];
    end
end
set(comp_desc, 'String', str);
