function job_plot_cmap_register_activity(inst_id)
% Store brain activity map into cortical activity file
% 
% [syntax]
% job_plot_cmap_print_spatialpattern(inst_id)
%
% [history]
% ????-??-?? Taku Yoshioka
% 2008-08-28 Taku Yoshioka
% 2008-10-23 Taku Yoshioka
% 2010-12-01 taku-y
%  [internal change] 'Jinfo' replaces 'MEGinfo'.
% 2010-12-06 taku-y
%  [enhancement] Jinfo.version>=0.9 supported. 
% 2010-12-08 taku-y
%  [internal change] vb_version_cmp used. 
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
% 2012-05-02 taku-y
%  [internal change] Use job_plot_cmap_get_spatialpattern() to get
%  spatial pattern to be registered. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end
if isempty(vbmeg_inst.plotcmap{inst_id}.Jact), return; end

% --- global variables
ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
t = vbmeg_inst.plotcmap{inst_id}.t;
Jinfo = vbmeg_inst.plotcmap{inst_id}.Jinfo;
Tstart = vbmeg_inst.plotcmap{inst_id}.Tstart;
V = vbmeg_inst.plotcmap{inst_id}.V;

% get current map
J0 = job_plot_cmap_get_spatialpattern(inst_id);

% store activity map
[brain_dir,brain_file] ...
    = vb_file_select({'.act.mat'},'Select activity map file');

if ~isempty(brain_file), 
  actfile = [brain_dir filesep brain_file{1}];
  
  prompt  = {'Enter activity map ID'};
  title   = 'Activity map registration';
  lines= 1;
  def     = {'new activity map'};
  str = inputdlg(prompt,title,lines,def);

  if isempty(str), 
    return;
  elseif ~isempty(str{1}),
    act_new.key = str{1};
    act_new.xxP = J0(:);
    
    vb_add_act(actfile,act_new);
  end
end

return;