function job_edit_area_erosion(inst_id)
%
% Dilation
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

% Stack
job_edit_area_stack(inst_id);

% Global variables
Iextract = vbmeg_inst.editarea{inst_id}.Iextract;
nextDD = vbmeg_inst.editarea{inst_id}.nextDD;
nextIX = vbmeg_inst.editarea{inst_id}.nextIX;
ed2 = vbmeg_inst.editarea{inst_id}.ed2;
ed3 = vbmeg_inst.editarea{inst_id}.ed3;

% Dilation
Rfilt = 1e-3*str2num(get(ed2,'String'));
Iextract{1} = vb_cut_area(Iextract{1},Rfilt,nextIX,nextDD);
vbmeg_inst.editarea{inst_id}.Iextract = Iextract;

% Update screen and vertex number
job_edit_area_update_spatialpattern(inst_id);
set(ed3,'String',num2str(length(Iextract{1})));

