function job_edit_act_replace(inst_id)
% Replace activity map with the selected one
%
% --- Syntax
% job_edit_act_replace(inst_id)
%
% --- History
% 2009-05-01 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.V), return; end
if isempty(vbmeg_inst.editact{inst_id}.xxP), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lb1 = vbmeg_inst.editact{inst_id}.lb1; 
actfile = vbmeg_inst.editact{inst_id}.actfile; 

%
% Calculate average
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Stack
job_edit_act_stack(inst_id);
xxP = vbmeg_inst.editact{inst_id}.xxP;

% Get activity map
i = get(lb1,'Value');
keyset = get(lb1,'String');
act = vb_get_act(actfile,keyset{i});

% Replace activity map
xxP{1} = act.xxP;
vbmeg_inst.editact{inst_id}.xxP = xxP;

%
% Update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_edit_act_update_spatialpattern(inst_id);
