function job_edit_act_normalize(inst_id)
% Normalize activity map
%
% --- Syntax
% job_edit_act_normalize(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.xxP), return; end

%
% Global variables
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lb1 = vbmeg_inst.editact{inst_id}.lb1; 
xxP = vbmeg_inst.editact{inst_id}.xxP;
h_fig = vbmeg_inst.editact{inst_id}.h_fig;
actfile = vbmeg_inst.editact{inst_id}.actfile; 

%
% Normalize activity map
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Stack
job_edit_act_stack(inst_id);

if (max(abs(xxP{1})))==0, return; end

% Get activity map
i = get(lb1,'Value');
keyset = get(lb1,'String');
act = vb_get_act(actfile,keyset{i});

% Average activity information
set(h_fig,'Pointer','watch');
xxP{1} = xxP{1}/max(abs(xxP{1}));
vbmeg_inst.editact{inst_id}.xxP = xxP;

%
% Update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_edit_act_update_spatialpattern(inst_id);
