function job_edit_act_load_cortex(inst_id,brainfile)
% Load cortical surface model
%
% --- Syntax
% function job_plot_cmap_load_cortex(inst_id,brainfile)
%
% --- History
% 2008-09-01 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Load cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist(brainfile),
  warndlg(['File ' brainfile ' does not exist.']);
  return; 
end

vbmeg_inst.editact{inst_id}.brainfile = brainfile;

% Cortical surface model
[Vinf,F,xx,inf_C,xxA] = vb_load_cortex(brainfile,'Inflate');

if ~isempty(vbmeg_inst.editact{inst_id}.xxP), 
  if length(vbmeg_inst.editact{inst_id}.xxP{1})~=size(Vinf,1), 
    warndlg(['Number of cortical vertices does not match with ' ...
             'that of the activity map.']);
  end
end
  
V = vb_load_cortex(brainfile);
vbmeg_inst.editact{inst_id}.V = V;
vbmeg_inst.editact{inst_id}.Vinf = Vinf;
vbmeg_inst.editact{inst_id}.F = F;
vbmeg_inst.editact{inst_id}.inf_C = inf_C;

% Standard brain coordinate
load(brainfile,'Vtal','Vmni');
if ~exist('Vtal','var'), Vtal = zeros(size(V)); end
if ~exist('Vmni','var'), Vmni = zeros(size(V)); end
vbmeg_inst.editact{inst_id}.Vtal = Vtal*1e3;
vbmeg_inst.editact{inst_id}.Vmni = Vmni*1e3;

% Load neighbour data for filter calculation
[nextDD,nextIX] = vb_load_cortex_neighbour(brainfile); 
vbmeg_inst.editact{inst_id}.nextDD = nextDD;
vbmeg_inst.editact{inst_id}.nextIX = nextIX;

% Activity map
vbmeg_inst.editact{inst_id}.xxP = cell(30,1);
for i=1:length(vbmeg_inst.editact{inst_id}.xxP)
  vbmeg_inst.editact{inst_id}.xxP{i} = zeros(size(V,1),1); 
end

%
% Update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_edit_act_update_spatialpattern(inst_id);
