function item = vb_input_settings_set_item(item)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

type = vb_input_settings_get_prop(item, 'type');

switch(type)
    case 'single file selection'
         title = vb_input_settings_get_prop(item, 'title');
         ext   = vb_input_settings_get_prop(item, 'extension');
         if ~iscell(ext)
             ext = {ext};
         end
         [d_, f_] = vb_file_select(ext, title, false);
         if ~isempty(d_) && ~isempty(f_)
             file = fullfile(d_, filesep, f_{1});
             item = vb_input_settings_set_prop(item, 'value', file);
         end
    case 'multiple file selection'
         title = vb_input_settings_get_prop(item, 'title');
         ext   = vb_input_settings_get_prop(item, 'extension');
         [d_, f_] = vb_file_select({ext}, title, false);
         if ~isempty(d_) && ~isempty(f_)
             for j=1:length(f_)
                 files{j} = fullfile(d_, filesep, f_{j});
             end
             item = vb_input_settings_set_prop(item, 'value', files);
         end
    case 'directory selection'
         d_ = vb_input_settings_get_prop(item, 'value');
         d = dir_dialog(d_);
         if ~isempty(d)
             item = vb_input_settings_set_prop(item, 'value', d);
         end
    case 'string input'
         title = vb_input_settings_get_prop(item, 'title');
         value = vb_input_settings_get_prop(item, 'value');
         if isempty(value)
             value = '';
         end
         str = inputdlg(title, 'Input', 1, {value});
         if isempty(str), return; end
         item = vb_input_settings_set_prop(item, 'value', str{1});
    otherwise
        error('Unknown edit type was specified.');
end

if nargout ~= 1
    error('function caller should receive item.');
end
