function vb_input_settings_callback(data, hObj)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

H = data.H;

switch(hObj)
    case {H.name_listbox, H.value_listbox}
        if strcmpi(get(H.fig, 'SelectionType'), 'open')
            % double click
            ix = get(H.name_listbox, 'Value');
            if ~isempty(ix)
                data.def{ix(1)} = vb_input_settings_set_item(data.def{ix(1)});
            end
        end
        vb_input_settings_update_gui(data);
    case H.edit_push
        ix = get(H.name_listbox, 'Value');
        if ~isempty(ix)
            data.def{ix(1)} = vb_input_settings_set_item(data.def{ix(1)});
        end
        vb_input_settings_update_gui(data);
    case H.input_seq_push
        data = vb_input_settings_set_sequencially(data);
        vb_input_settings_update_gui(data)
    case H.saveas_push
        feval(data.save_func, data.def);
    case H.ok_push
        data.cancel = false;
        set(H.fig, 'Visible', 'off');
    case {H.cancel_push, H.fig}
        if isequal(data.org_def, data.def)
            data.cancel = true;
            set(H.fig, 'Visible', 'off');
        else
            res = questdlg('Are you sure?', 'Confirm', 'Yes', 'No', 'Yes');
            if strcmpi(res, 'yes')
                data.cancel = true;
                set(H.fig, 'Visible', 'off');
            end
        end
%     case H.fig
%         % close request
%         data.cancel = true;
%         set(H.fig, 'Visible', 'off');
end

guidata(H.fig, data);

