function varargout = select_xrange(key, varargin)
% select_xrange( key, varargin )
%
%  2դxϰϤޥɥåǻꤹ뤿
%  Хå롼Ǥ
%
% key :  'init'  'delete'  'get'  'clear'  'SetBoxColor'
%        'SetReturnVariable'  'SetButtonUpFcn'  'SetInitialRange'
%
%   select_xrange( 'init', <axes handle>
%       [ , 'BoxColor', <color> ]
%       [ , 'ReturnVariable', <variable name> ]
%       [ , 'ButtonUpFcn', <function string> ]
%       [ , 'InitialRange', <range> ] )
%     <axes handle> ǻꤵ륰դоݤꤷޤ
%     Ȥơ'BoxColor', 'BoxStyle',
%     'ReturnVariable', 'ButtonUpFcn', 'InitialRange' Ǥ
%     줾Υץξܺ٤ϲ򻲾ȤƤ
%
%   select_xrange( 'delete', <axes handle> )
%     <axes handle> ǻꤵ륰դоݤޤ
%
%   select_xrange( 'get', <axes handle> )
%     <axes handle> ǻꤵ륰դˤ븽ߤϰϤ
%     ޤϷ [ , 峦 ] Ǥ
%
%   select_xrange( 'clear', <axes handle> )
%     <axes handle> ǻꤵ륰դϰϤõޤ
%   
%   select_xrange( 'SetBoxColor', <axes handle>, <color> );
%     <axes handle> ǻꤵ륰դˤϰϤ򼨤BOXο
%     ꤷޤ<color>MatlabColorSpec˽򤷤ޤǥե
%     ͤ [ 1.0, 0.6, 0.6 ] Ǥ
%
%   select_xrange( 'SetReturnVariable', <axes_handle>, <variable name> );
%     <axes handle> ǻꤵ륰դˤϰϤϤ뤿
%     ΥХѿ̾ꤷޤ<variable name> ѿ̾
%     ʸˤʤޤǥեȤ϶Ǥ
%
%   select_xrange( 'SetButtonUpFcn', <axes_handle>, <command> );
%     <axes handle> ǻꤵ륰դˤɥåλ˼¹
%     륳ޥɤꤷޤǡ򤷤ϰϤѤˤϡ
%     xrange Ȥѿ̾ѤƲ㤨С
%       >> select_xrange( 'SetButtonUpFcn', 'func( xrange, var )' );
%     ʤɤˤꡢϰϤؿfuncΰȤϤޤǥե
%     Ȥ϶Ǥ
%
%   select_xrange( 'SetInitialRange', <range> );
%     <axes handle> ǻꤵ륰դˤϰϤνͤ
%     ꤷޤѤ뤳ȤˤꡢޥɥåʳǤϰ
%     ꤬ǽǤ<range>2ǤΥ٥ȥǡ줾xϰϤ
%     峦ͤȲͤ򼨤ޤޥɥåǤϡɽդ
%     礭ϰϻϤǤޤ󤬡ǤϲǽǤǥեȤ
%     Ǥ
%
%
% [ ñʻȤ ]
%
%   ޤоݤȤʤ륰դ axes handle ꤷޤ
%
%   >> select_xrange( 'set', <axes handle> );
%
%   ˤꡢоݥդޥǥɥå
%   򤵤줿xϰϤͳѷǰϤޤޤ
%   ϰϤ˥ˤϡ
%
%   >> select_xrange( 'get', <axes handle> );
%
%   ȤƤ
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)




switch key

 % -----------------------------------------------------------------
 %  key : init
 % -----------------------------------------------------------------
 case 'init'  % axes  select_xrange оݤȤ

  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end

  % åԴ  %%% 
  if mod( size(varargin,2), 2 ) ~= 1
    disp( 'invalid arguments for select_xrange( ''set'', ... )' );
    return;
  end 
  i = 2;
  while i < size(varargin,2)
    switch varargin{i}
     case 'BoxColor'
      boxcolor = varargin{i+1};
     case 'ReturnVariable'
      retvar = varargin{i+1};
     case 'ButtonUpFcn'
      upfcn = varargin{i+1};
     case 'InitialRange'
      xrange = varargin{i+1};
     otherwise
      disp( 'invalid arguments for select_xrange( ''set'', ... )' );
      return;
    end
    i = i + 2;
  end
  % ---- åλ
  
  % ץΥǥե
  if ~exist('boxcolor'); boxcolor = [0.6,0.6,0.6]; end
  if ~exist('retvar'); retvar = []; end
  if ~exist('upfcn'); upfcn = []; end
  if ~exist('xrange'); xrange = []; end
  
  % axes  ޥܥ򲡤ȤΥХå
  set( h, 'ButtonDownFcn',...
	  [ 'select_xrange(''down'',''' retvar ''',''' upfcn ''');' ] );

  % ¸ϰBOXк
  boxhandle = findobj( gca, 'Tag', 'SelX_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
  end
  
  boxhandle = findobj( gca, 'Tag', 'SelXY_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
  end
  
  % ϰBOX
  ylim = get( h, 'YLim' );
  if isempty(xrange)
    xlim = get( h, 'XLim' );
    xinf = xlim(1);
    xsup = xlim(2);
  else
    xinf = xrange(1);
    xsup = xrange(2);
  end
  if vb_matlab_version('<', '8.4.0')
      boxhandle = ...
          patch( [ xinf, xsup, xsup, xinf ],...
             [ ylim(1), ylim(1), ylim(2), ylim(2) ], ...
             boxcolor, 'HitTest', 'off', 'Visible', 'off',...
             'EraseMode', 'xor', 'Tag', 'SelX_BOX' );
  else
      boxhandle = ...
          patch( [ xinf, xsup, xsup, xinf ],...
             [ ylim(1), ylim(1), ylim(2), ylim(2) ], ...
             boxcolor, 'HitTest', 'off', 'Visible', 'off',...
             'Tag', 'SelX_BOX' );
      boxhandle.FaceAlpha = 0.5;
  end
  if ~isempty(xrange)
    set( boxhandle, 'Visible', 'on' );
  end
  % ----- 



 % -----------------------------------------------------------------
 %  key : delete
 % -----------------------------------------------------------------
 case 'delete'  % axes  select_xrange оݤ
  
  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end

  % ϰBOXк (BOX'init'ɬ)
  boxhandle = findobj( gca, 'Tag', 'SelX_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
    set( h, 'ButtonDownFcn', [] );
  end
  
  boxhandle = findobj( gca, 'Tag', 'SelXY_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
    set( h, 'ButtonDownFcn', [] );
  end



 % -----------------------------------------------------------------
 %  key : down
 % -----------------------------------------------------------------
 case 'down' % ޥܥ󤬲줿Ȥ (Box,
             % WindowButtonMotionFcn, WindowButtonUpFcn )

  %  : retvar --- ѥХѿ,  
  %        upfcn --- ޥܥΥȤΥޥ
  retvar = varargin{1};
  upfcn = varargin{2};

  % ͭʤΤϺåΤ
  if strcmp( get( gcf, 'SelectionType' ), 'normal' ) == 0
    return;
  end
  
  % BOXκ
  acpt = get( gca, 'CurrentPoint' );  
  xlim = get( gca, 'XLim' );
  ylim = get( gca, 'YLim' );
  xini = max( xlim(1), acpt(1) ); % ϰ
  xini = min( xlim(2), xini );    % դaxisΤ
  boxhandle = findobj( gca, 'Tag', 'SelX_BOX' ); % BOXΥϥɥ
  set( boxhandle, 'XData', [ xini, xini, xini, xini ],...
		  'Visible', 'on' );
  
  % ޥưȤȥܥΥȤΥХå
  set( gcf, 'WindowButtonMotionFcn', 'select_xrange(''move'')' );
  if isempty( retvar )
    set( gcf, 'WindowButtonUpFcn',...
	      [ 'select_xrange(''up'',''' upfcn ''');' ] );
  else
    set( gcf, 'WindowButtonUpFcn',...
	      [ retvar ' = select_xrange(''up'',''' upfcn ''');' ] );
  end
  
 

 % -----------------------------------------------------------------
 %  key : move
 % -----------------------------------------------------------------
 case 'move' % ޥưȤ

  % BOXκ
  acpt = get( gca, 'CurrentPoint' );
  xlim = get( gca, 'XLim' );
  xcur = max( xlim(1), acpt(1) ); % ϰ
  xcur = min( xlim(2), xcur );    % դaxisΤ
  boxhandle = findobj( gca, 'Tag', 'SelX_BOX' ); % BOXΥϥɥ
  temp = get( boxhandle, 'XData' );
  xini = temp(1);
  set( boxhandle, 'XData', [ xini, xcur, xcur, xini ] );
    


 % -----------------------------------------------------------------
 %  key : up
 % -----------------------------------------------------------------
 case 'up' % ޥܥΥȤ

  %  : upfcn --- ޥܥΥȤΥޥ
  upfcn = varargin{1};
  
  % ޥưȤȥޥܥΥȤΥХåβ
  set( gcf, 'WindowButtonMotionFcn', [] );
  set( gcf, 'WindowButtonUpFcn', [] );
  
  % BOXκ
  acpt = get( gca, 'CurrentPoint' );
  xlim = get( gca, 'XLim' );
  xcur = max( xlim(1), acpt(1) );
  xcur = min( xlim(2), xcur );
  boxhandle = findobj( gca, 'Tag', 'SelX_BOX' );
  temp = get( boxhandle, 'XData' );
  xini = temp(1);
  set( boxhandle, 'XData', [ xini, xcur, xcur, xini ] );
  
  % ϰ
  xrange = sort( [ xini, xcur ] );
  
  % 桼ؿƤӽФ
  if ~isempty( upfcn )
    eval( upfcn );
  end
  
  % ͤȤƽ
  varargout{1} = xrange;
  

 
 % -----------------------------------------------------------------
 %  key : get
 % -----------------------------------------------------------------
 case 'get' % ϰϤμ
  
  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    varargout{1} = [];
    return;
  end
  
  % BOXΥϥɥ  н
  boxhandle = findobj( h, 'Tag', 'SelX_BOX' );
  if ~isempty(boxhandle) &...
     strcmp( get( boxhandle, 'Visible' ), 'on' ) == 1;
    xdat = get( boxhandle, 'XData' );
    xrange = sort( [ xdat(1), xdat(2) ] );
    varargout{1} = xrange;
  else
    varargout{1} = [];
  end
  


 % -----------------------------------------------------------------
 %  key : clear
 % -----------------------------------------------------------------
 case 'clear'  % BOXξõ
  
  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end

  % BOXΥϥɥ  Ļ벽
  boxhandle = findobj( h, 'Tag', 'SelX_BOX' );
  if ~isempty(boxhandle)
    xlim = get( h, 'XLim' );
    set( boxhandle, 'Visible', 'off' );
  end



 % -----------------------------------------------------------------
 %  key : SetBoxColor
 % -----------------------------------------------------------------
 case 'SetBoxColor'  % ϰBOXο (Դ) %%%
  
  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end
  
  %  : ꤹ뿧 (åɬ)
  boxcolor = varargin{2};

  % BOXΥϥɥ  пѹԴ %%%
  boxhandle = findobj( h, 'Tag', 'SelX_BOX' );
  if ~isempty(boxhandle)
    set( boxhandle, 'FaceVertexCData', boxcolor );
  end
  


 % -----------------------------------------------------------------
 %  key : SetReturnVariable
 % -----------------------------------------------------------------
 case 'SetReturnVariable' % ܥΥȤϰϤϤ
                          % ΥХѿ

  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end

  %  : ꤹѿ (åɬסԲǽ) %%%
  retvar = varargin{2};

  % axes ButtonDownFcn Хåνľ
  bdf = get( h, 'ButtonDownFcn' );
  i = findstr( bdf, 'select_xrange' );
  if ~isempty( i )
    c = findstr( bdf, ',' );
    set( h, 'ButtonDownFcn',...
	    [ bdf(1:c(1)+1), retvar, bdf(c(2)-1:size(bdf,2)) ] );
  end
  
  

 % -----------------------------------------------------------------
 %  key : SetButtonUpFcn
 % -----------------------------------------------------------------
 case 'SetButtonUpFcn'  % ܥΥȤ˼¹Ԥ륳ޥɤ

  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end

  %  : ꤹ륳ޥ (åɬסԲǽ) %%%
  upfcn = varargin{2};
  
  % axes ButtonDownFcn Хåνľ
  bdf = get( h, 'ButtonDownFcn' );
  i = findstr( bdf, 'select_xrange' );
  if ~isempty( i )
    c = findstr( bdf, ',' );
    set( h, 'ButtonDownFcn',...
	    [ bdf(1:c(2)+1), upfcn, ''');' ] );
  end


 % -----------------------------------------------------------------
 %  key : SetInitialRange
 % -----------------------------------------------------------------
 case 'SetInitialRange'  % ޥɥåϰϤ
  
  % axes handle 
  h = varargin{1};
  if ~ishandle(h) | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in select_xrange: invalid axes handle' );
    return;
  end
  
  %  : ꤹϰ (åɬ) %%%
  xrange = varargin{2};
  
  % BOXΥϥɥ  кĻ벽
  boxhandle = findobj( h, 'Tag', 'SelX_BOX' );
  if ~isempty(boxhandle)
    set( boxhandle, 'XData', [xrange(1),xrange(2),xrange(2),xrange(1)],...
		    'Visible', 'on');
  end


  
 % -----------------------------------------------------------------
 %  key : ¾ ʥ顼
 % -----------------------------------------------------------------
 otherwise
  disp( 'Invalid key for select_xrange()' );


  
end % switch key

