function [data] = project_mgr_set_ix_for_check_model(data, parm_type, ix)
% set index for check model
% [USAGE]
%    [data] = project_mgr_set_ix_for_check_model(<data>, <parm_type>, <ix>);
% [IN]
%         data : project_mgr data
%    parm_type : 'brain_parm' or 'fmri_parm' or 'meg_parm' (char array)
%           ix : selected line number of parameter list.   (scalar)
% [OUT]
%   data : project_mgr data(updated)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end

%
% --- Main Procedure
%
switch(parm_type)
    case 'brain_parm'
        data.parm_ix_for_check_model(1) = ix;
    case 'fmri_parm'
        data.parm_ix_for_check_model(2) = ix;
    case 'meg_parm'
        data.parm_ix_for_check_model(3) = ix;
    otherwise
        error('invalid parm_type is specified.');
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive data.');
end
