function project_mgr_launch_module(in_fig, module_name, init_parm)
% launch module.
% [USAGE]
%    project_mgr_launch_module(<in_fig>, <module_name>[, init_parm]);
% [IN]
%         in_fig : figure handle of project_mgr gui.
%    module_name : modules calls    : This function.
%                  'brain'          : vb_job_brain
%                  'fmri'           : vb_job_fmri
%                  'biosemi_eeg'    : vb_job_meg(with biosemi parameter)
%                  'brainamp_eeg'   : vb_job_meg(with brainamp parameter)
%                  'sbi_meg'        : vb_job_meg(with sbi parameter)
%                  'yokogawa_meg'   : vb_job_meg(with yokogawa parameter)
%                  'leadfield'      : vb_job_leadfield
%                  'bayes'          : vb_job_vb
%                  'current'        : vb_job_current
%                  'spm_curry_head' : vb_job_head_1shell / vb_job_head_3shell
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('in_fig', 'var') || isempty(in_fig) || ~ishandle(in_fig)
    error('invalid figure handle is specified.');
end
if ~exist('module_name', 'var') || isempty(module_name)
    error('invalid module_name is specified.');
end
if ~exist('init_parm', 'var')
    init_parm = [];
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(in_fig);
proj_root = get(data.H.project_root_edit, 'String');

fig = [];

switch(module_name)
    case 'brain'
        if isfield(init_parm, 'std_brain') || ...
           isfield(init_parm, 'subj_mask')
            % brain_parm is for (standard brain or subject smooth brain)
            obj = brain_file_maker_new(proj_root);
            obj = brain_file_maker_set_parm(obj, init_parm);
            fig = brain_file_maker_get_figure_handle(obj);
            data.tools_fig = [data.tools_fig; fig];
        else
            % brain_parm is for import BrainVoyager or FreeSurfer
            fig = pa_brain_create(proj_root);
            if ishandle(fig)
                pa_brain_set_parm(fig, init_parm);
                data.pa_brain_fig = [data.pa_brain_fig; fig];
            end
        end
    case 'fmri'
        fig  = pa_fmri_create(proj_root);
        if ishandle(fig)
            pa_fmri_set_parm(fig, init_parm);
            data.pa_fmri_fig = [data.pa_fmri_fig; fig];
        end
    case 'biosemi_eeg'
        fig = pa_biosemi_eeg_create(proj_root);
        if ishandle(fig)
            pa_biosemi_eeg_set_parm(fig, init_parm);
            data.pa_biosemi_eeg_fig = [data.pa_biosemi_eeg_fig; fig];
        end
    case 'brainamp_eeg'
        fig = pa_brainamp_eeg_create(proj_root);
        if ishandle(fig)
            pa_brainamp_eeg_set_parm(fig, init_parm);
            data.pa_brainamp_eeg_fig = [data.pa_brainamp_eeg_fig; fig];
        end
    case 'sbi_meg'
        fig = pa_sbi_meg_create(proj_root);
        if ishandle(fig)
            pa_sbi_meg_set_parm(fig, init_parm);
            data.pa_sbi_meg_fig = [data.pa_sbi_meg_fig; fig];
        end
    case 'yokogawa_meg'
        fig = pa_yokogawa_meg_create(proj_root);
        if ishandle(fig)
            pa_yokogawa_meg_set_parm(fig, init_parm);
            data.pa_yokogawa_meg_fig = [data.pa_yokogawa_meg_fig; fig];
        end
    case 'spm_curry_head'
        fig = pa_head_create(proj_root);
        if ishandle(fig)
            pa_head_set_parm(fig, init_parm);
            data.pa_head_fig = [data.pa_head_fig; fig];
        end
    case 'leadfield'
        fig = pa_leadfield_create(proj_root);
        if ishandle(fig)
            pa_leadfield_set_parm(fig, init_parm);
            data.pa_leadfield_fig = [data.pa_leadfield_fig; fig];
        end
    case 'bayes'
        fig = bayes_parm_editor_init(proj_root, init_parm);
        if ishandle(fig)
            data.bayes_fig = [data.bayes_fig; fig];
        end
    case 'current'
        fig = current_gui_new(proj_root, init_parm);
        if ishandle(fig)
            data.current_fig = [data.current_fig; fig];
        end
end

% save data
guidata(in_fig, data);
